block('b-regions-tree').mod('bids-corrections', 'yes')(
    def()(function() {

        return applyNext({
            disableEditBids: this.ctx.disableEditBids
        });
    }),

    elem('region')(
        def().match(function() { return this.ctx.region.bid != undefined; })(function() {
            return applyNext({
                'elemMods.bid': 'yes'
            });
        }),

        content()(function() {
            var region = this.ctx.region;

            return [
                applyNext(),
                {
                    elem: 'region-bid',
                    elemMods: {
                        'editable': this.disableEditBids ? '' : 'yes'
                    },
                    attrs: {
                        title: iget2('b-regions-tree', 'redaktirovat', 'Редактировать')
                    },
                    content: [
                        {
                            elem: 'region-bid-value',
                            tag: 'span',
                            attrs: { id: 'region-bid-value-' + region.id },
                            content: {
                                elem: 'region-bid-value-text',
                                value: region.bid != undefined ? region.bid : (region.defaultBid || 0)
                            }
                        },
                        !this.disableEditBids && {
                            block: 'icon',
                            mods: { 'size-16': 'edit', theme: 'light' },
                            mix: [
                                {
                                    block: 'b-regions-tree',
                                    elem: 'edit-bid'
                                }
                            ]
                        }
                    ]
                }
            ];
        })
    ),

    elem('region-bid-value-text')(

        def()(function() {
            var bid = this.ctx.value,
                bidMode = '';

            if (bid > 0) {
                bidMode = 'up';
            } else if (bid < 0) {
                bidMode = 'down';
            }

            return applyNext({
                'elemMods.mode': bidMode
            });
        }),

        tag()('span'),

        content()(function(){
            return iget2('b-regions-tree', 's', '{foo} %', {
                foo: Math.abs(this.ctx.value)
            });
        })
    )
);
