BEM.DOM.decl({ block: 'b-regions-tree', modName: 'bids-corrections', modVal: 'yes' }, {
    /**
     * Возвращает информацию о установленных для регионов ставках
     * @returns {Object}
     */
    getBids: function() {
        var data = this._data;

        return Object.keys(data).reduce(function(result, regionId) {
            if (data[regionId].bid != undefined) {
                result[regionId] = data[regionId].bid;
            }

            return result;
        }, {});
    },

    /**
     * Сброс всеx ставок
     */
    resetBids: function() {
        var allElems = this.elem('region-bid-value');

        allElems.html(BEMHTML.apply({
            block: 'b-regions-tree',
                mods: { 'bids-corrections': 'yes' },
                elem: 'region-bid-value-text',
                value: 0
            }));
        this.delMod(allElems, 'mode');
        this.delMod(this.elem('region'), 'bid');

        Object.keys(this._data).forEach(function(regionId) {
            this._data[regionId].bid = undefined;
            this._data[regionId].defaultBid = 0;
        }, this);
    },

    /**
     * Изменение ставки у региона
     * @param {String} regionId идентификатор региона
     * @param {Number|undefined} bidValue значение ставки (undefined, если ставку надо сбросить)
     */
    _changeBid: function(regionId, bidValue) {
        var region = this._data[regionId];

        region.bid = bidValue;
        this._replaceBidValueForRegion(regionId, bidValue != undefined ? bidValue : region.defaultBid);
        this.setMod(this.elem('region', 'id', regionId), 'bid', bidValue != undefined ? 'yes' : '');

        this._changeBidsForInnerRegions(regionId);
    },

    /**
     * Изменение ставки у наследников региона
     * @param {String} regionId идентификатор региона
     */
    _changeBidsForInnerRegions: function(regionId) {
        var region = this._data[regionId];

        region.inners.forEach(function(innerRegionId) {
            var innerRegion = this._data[innerRegionId],
                innerBidValue = region.bid != undefined ? region.bid : region.defaultBid;

            innerRegion.defaultBid = innerBidValue;

            this._changeBidsForInnerRegions(innerRegionId);

            if (innerRegion.bid != undefined) {
                return;
            }

            this._replaceBidValueForRegion(innerRegionId, innerBidValue);
        }, this);
    },

    /**
     * Меняет значение ставки у региона в разметке
     * @param {String} regionId идентификатор региона
     * @param {Number} bidValue значение ставки
     */
    _replaceBidValueForRegion: function(regionId, bidValue) {

        document.getElementById('region-bid-value-' + regionId).innerHTML = BEMHTML.apply({
            block: 'b-regions-tree',
                mods: { 'bids-corrections': 'yes' },
                elem: 'region-bid-value-text',
                value: bidValue
            });
    },

    /**
     * Инициализирует и возвращает bem-блок попапа, в котором будет форма редактирования ставки
     * @returns {BEM}
     */
    _getEditBidPopup: function() {
        if (!this._editBidPopup) {
            this._editBidPopup = BEM.blocks['b-shared-popup'].getInstance(
                {
                    'fade-out': 'no',
                    adaptive: 'yes',
                    'has-close': 'no'
                },
                {
                    directions: ['bottom', 'top']
                });

            this.bindTo(this.domElem, 'scroll', function() {
                this._editBidPopup.hide();
            });

            this._editBidPopup.on('hide', function() {
                if (this._currentEditBidBlock) {
                    this._currentEditBidBlock.un('cancel');
                    this._currentEditBidBlock.un('save');
                    this._currentEditBidBlock.destruct();
                    this._currentEditBidBlock = null;
                }

                this._editBidPopupIsOpened = false;
            }, this);
        }

        return this._editBidPopup;
    },

    /**
     * Инициализирует блок редактирования ставки региона
     * @param {String} regionId идентификатор региона
     * @param {Number} bidValue значение ставки
     */
    _initEditRegionBidBlock: function(regionId, bidValue) {
        var editBidPopup = this._getEditBidPopup(),
            editRegionBidBlock;

        editBidPopup.setContent(BEMHTML.apply({
                block: 'b-edit-region-bid',
                mix: {
                    block: 'b-regions-tree',
                    elem: 'edit-bid-popup-content'
                },
                value: bidValue
            }));

        this._currentEditBidBlock = editBidPopup.findBlockInside('b-edit-region-bid');

        this._currentEditBidBlock.on('cancel', function() {
            editBidPopup.hide();
        });

        this._currentEditBidBlock.on('save', function(event, data) {
            editBidPopup.hide();

            this._changeBid(regionId, data.value !== '' ? data.value : undefined);
        }, this);
    },

    /**
     * Обработчик события нажатия на кнопку редактирования ставки
     * @param {Event} e Событие клика
     */
    _onEditBidButtonClick: function(e) {
        var domElem = e.data.domElem,
            regionDom = this._getRegionByChildDomNode(domElem),
            editBidPopup = this._getEditBidPopup(),
            regionDataItem = this._data[this.getMod(regionDom, 'id')];

        this._initEditRegionBidBlock(this.getMod(regionDom, 'id'), regionDataItem.bid);

        editBidPopup.show(domElem);
        this._currentEditBidBlock.setMod('focused', 'yes');

        this._editBidPopupIsOpened = true;
    }
}, {
    live: function() {
        this.__base.apply(this, arguments);

        this.liveBindTo({ elem: 'region-bid', modName: 'editable', modVal: 'yes' }, 'click', function(e) {
            !this._editBidPopupIsOpened && this._onEditBidButtonClick(e);
        });
    }
});
