block('b-regions-tree')(
    def()(function() {
        return applyNext({
            isCommon: this.ctx.isCommon,
            regions: this.ctx.regions,
            disableRegions: (this.ctx.disableRegions || []).reduce(function(res, regionId) {
                    res[regionId] = true;

                    return res;
                }, {}),
            independentRegions: (this.ctx.independentRegions || []).reduce(function(res, regionId) {
                    res[regionId] = true;

                    return res;
                }, {}),
            quickSelectRegions: this.ctx.quickSelectRegions,
            hintForDifferentRegions: this.ctx.hintForDifferentRegions
        });
    }),

    js()(function() {
        var prepare = function(roots, region) {
                roots[region.id] = {
                    name: region.name,
                    bid: region.bid,
                    defaultBid: region.defaultBid || 0,
                    extraParams: region.extraParams,
                    contrastValueGroups: region.contrastValueGroups,
                    inners: (region.inner || []).map(function(inner) {
                        prepare(roots, inner);

                        return inner.id;
                    })
                };
            },
            walkTree = function (roots, cb) {
                var nodesToProcess = roots.slice();
                while (nodesToProcess.length) {
                    var node = nodesToProcess.shift();
                    cb(node);
                    nodesToProcess.push.apply(nodesToProcess, node.inner || []);
                }
            },
            walkOrder = [];
        
        walkTree(this.regions, function(region) { walkOrder.push(region.id); });

        return {
            roots: this.regions.reduce(function(roots, region) {
                prepare(roots, region);

                return roots;
            }, {}),
            walkOrder: walkOrder,
            hasIndependentRegions: Object.keys(this.independentRegions).length,
            isCommon: this.isCommon,
            hintForDifferentRegions: this.hintForDifferentRegions
        };
    }),

    content()(function() {
        return this.regions.map(function(region) {
            return {
                elem: 'node-wrap',
                region: region
            };
        }, this);
    }),

    elem('node-wrap').content()(function() {
        var region = this.ctx.region,
            isIndependent = this.independentRegions[region.id];

        return [
            {
                elem: 'region',
                elemMods: {
                    id: region.id,
                    expanded: 'no',
                    'has-inner': region.inner ? 'yes' : 'no',
                    visible: this.disableRegions[region.id] ? 'no' : ''
                },
                region: region,
                isIndependent: isIndependent,
                hasIndependentParent: this.ctx.hasIndependentParent
            },

            region.inner && !this.disableRegions[region.id] && {
                elem: 'inner',
                elemMods: { visible: 'no', 'parent-id': region.id },
                content: region.inner.map(function(innerRegion) {
                    return {
                        elem: 'node-wrap',
                        region: innerRegion,
                        hasIndependentParent: isIndependent || this.ctx.hasIndependentParent
                    };
                }, this)
            }
        ];
    }),

    elem('region').content()(function() {

        return [
            this.ctx.region.inner && {
                elem: 'expander',
                content: [
                    { elem: 'expand'},
                    { elem: 'collapse'}
                ]
            },
            {
                elem: 'region-info',
                content: [
                    {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-regions-tree',
                            elem: 'region-checkbox',
                            elemMods: { id: this.ctx.region.id }
                        }],
                        checkboxAttrs: { id: 'region-' + this.ctx.region.id },
                        mods: {
                            size: 's',
                            theme: 'normal',
                            disabled: this.disableRegions[this.ctx.region.id] ? 'yes' : '',
                            independent: this.ctx.isIndependent ? 'yes' : '',
                            'independent-parent': !this.ctx.isIndependent && this.ctx.hasIndependentParent ? 'yes' : ''
                        },
                        text: {
                            elem: 'label',
                            mix: {
                                block: 'b-regions-tree',
                                elem: 'region-name'
                            },
                            content: this.ctx.region.name
                        }
                    },
                    this.isCommon && this.ctx.region.contrastValueGroups && {
                        elem: 'contrast-value-hint',
                        contrastValueGroups: this.ctx.region.contrastValueGroups
                    }
                ]
            }
        ]
    }),

    elem('contrast-value-hint').replace()(function() {
        return [
            {
                block: 'icon',
                mods: { 'size-13': 'info', theme: 'light' },
                mix: {
                    block: 'b-regions-tree',
                    elem: 'contrast-value-hint'
                }
            }
        ]
    }),

    // contrast-value-info - переопределяется в Директе
    elem('contrast-value-info').content()(function() {
       var itemsNumber = this.ctx.groups.length;

       return [
           iget2('b-regions-tree', 'gruppy-v-kotoryh-dannyy', 'Группы, в которых данный регион показа выключен:'),
           {
               elem: 'contrast-value-items',
               content: itemsNumber > 30 ?
                   {
                       elem: 'contrast-value-items-text',
                       content: iget2('b-regions-tree', 'v-s-region-pokaza', 'В {foo} регион показа выключен. Список слишком длинный для показа.', {
                           foo: u.pluralize([iget2('b-regions-tree', 'gruppe', 'группе'), iget2('b-regions-tree', 'gruppah', 'группах'), iget2('b-regions-tree', 'gruppah', 'группах')], itemsNumber)
                       })
                   } :
                   this.ctx.groups.map(function(group) {

                       return {
                               elem: 'contrast-value-item',
                               content: [
                                   {
                                       block: 'link',
                                       url: group.url,
                                       target: '_blank',
                                       content: group.name
                                   },
                                   {
                                       elem: 'contrast-value-item-id',
                                       content: group.id
                                   }
                               ]
                           }
                   })
           }
       ];
    })
);
