block('b-regions').mod('bids-corrections', 'yes')(
    elem('quick-controls').content()(function() {
        return [
            {
                elem: 'quick-controls-section',
                content: [
                    {
                        elem: 'bids-corrections-mode-title',
                        mix: {
                            elem: 'quick-controls-head'
                        },
                        content: iget2('b-regions', 'korrektirovki-stavok', 'Корректировки ставок')
                    },
                    this.disableEditBids ?
                        this.disableEditBidsHint || iget2('b-regions', 'redaktirovanie-korrektirovok-stavok-nedostupno', 'Редактирование корректировок ставок недоступно') :
                        {
                            block: 'tumbler',
                            mods: {
                                size: 's',
                                theme: 'normal',
                                checked: this.isBidsCorrectionsModeOn ? 'yes' : ''
                            },
                            mix: {
                                block: 'b-regions',
                                elem: 'bids-corrections-mode-switcher'
                            }
                        }
                ]
            },
            applyNext()
        ];
    }),

    elem('tree').replace()(function() {

        return {
            block: 'b-regions-tree',
            mods: {
                'bids-corrections': 'yes',
                'bids-corrections-mode': this.isBidsCorrectionsModeOn ? 'on' : ''
            },
            mix: {
                block: 'b-regions',
                elem: 'tree'
            },
            isCommon: this.isCommon,
            disableEditBids: this.disableEditBids,
            disableRegions: this.disableRegions,
            independentRegions: this.independentRegions,
            regions: this.regions,
            hintForDifferentRegions: this.hintForDifferentRegions
        }
    }),

    elem('tree-controls').content()(function() {

        return [
            applyNext(),
            !this.disableEditBids && {
                block: 'link',
                mods: { pseudo: 'yes', theme: 'ghost' },
                mix: {
                    block: 'b-regions',
                    elem: 'reset-bids',
                    elemMods: {
                        visible: this.isBidsCorrectionsModeOn ? 'yes' : ''
                    }
                },
                content: iget2('b-regions', 'ochistit-korrektirovki', 'Очистить корректировки')
            }
        ];
    })
);
