BEM.DOM.decl({ block: 'b-regions', modName: 'bids-corrections', modVal: 'yes' }, {
    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._bidsCorrectionsModeSwitcher = this.findBlockOn('bids-corrections-mode-switcher', 'tumbler');
        }
    },

    /**
     * Возвращает информацию о выбранных регионах в виде объекта {ids, text}
     * @returns {{ids: (string|number), text: (string|*), bids: Object, isBidsCorrectionsModeOn: Boolean}}
     * @override
     */
    getRegionsData: function() {
        var result = this.__base.apply(this, arguments),
            regionsTree = this._getRegionsTree();

        result.bids = regionsTree.getBids();

        result.isBidsCorrectionsModeOn = !!regionsTree.getMod('bids-corrections-mode');

        return result;
    },

    /**
     * Включает/выключает режим редактирования корректировок ставок
     * @param {Boolean} isModeOn
     */
    _toggleBidsCorrectionsMode: function(isModeOn) {
        this._getRegionsTree().setMod('bids-corrections-mode', isModeOn ? 'on' : '');
        this.setMod(this.elem('reset-bids'), 'visible', isModeOn ? 'yes' : '');
    },

    /**
     * Обработчик события клика блока link
     * @param {jQuery.Event} e
     * @override
     */
    _handleLinkClick: function(e) {
        var domElem = e.block.domElem;

        this.__base.apply(this, arguments);

        if (this.elem('reset-bids').is(domElem)) {
            this._getRegionsTree().resetBids();
        }
    }
}, {
    live: function() {
        this.__base.apply(this, arguments);

        this
            .liveInitOnBlockInsideEvent('change', 'tumbler', function(e, data) {
                this._toggleBidsCorrectionsMode(data.checked);
            });
    }
});
