block('b-regions')(
    def()(function() {
        return applyNext({
            isCommon: this.ctx.isCommon,
            regions: this.ctx.regions,
            disableRegions: this.ctx.disableRegions,
            independentRegions: this.ctx.independentRegions,
            quickSelectRegions: this.ctx.quickSelectRegions,
            disableEditBids: this.ctx.disableEditBids,
            disableEditBidsHint: this.ctx.disableEditBidsHint,
            isBidsCorrectionsModeOn: this.ctx.isBidsCorrectionsModeOn,
            hintForDifferentRegions: this.ctx.hintForDifferentRegions
        });
    }),

    js()(true),

    content()(function() {

        return [
            {
                elem: 'regions-tree-wrapper'
            },
            {
                elem: 'quick-controls'
            }
        ];
    }),

    elem('regions-tree-wrapper').content()(function() {

        return [
            {
                elem: 'search',
                content: [
                    {
                        block: 'input',
                        mix: [
                            {
                                block: 'b-regions',
                                elem: 'search-input'
                            }
                        ],
                        mods: {
                            suggest: 'yes',
                            size: 's',
                            theme: 'normal',
                            autofocus: 'yes'
                        },
                        js: {
                            dataprovider: { name: 'i-suggest-dataprovider' }
                        },
                        placeholder: iget2('b-regions', 'nayti-region', 'Найти регион'),
                        content: { elem: 'control' }
                    },
                    {
                        elem: 'no-search-result',
                        content: iget2('b-regions', 'nichego-ne-naydeno', 'Ничего не найдено')
                    }
                ]
            },
            { elem: 'tree' },
            {
                elem: 'tree-controls',
                content: {
                    elem: 'reset-selected'
                }
            }
        ];
    }),

    elem('tree').replace()(function() {

        return {
            block: 'b-regions-tree',
            mix: {
                block: 'b-regions',
                elem: 'tree'
            },
            isCommon: this.isCommon,
            disableRegions: this.disableRegions,
            independentRegions: this.independentRegions,
            regions: this.regions,
            hintForDifferentRegions: this.hintForDifferentRegions
        }
    }),

    elem('quick-controls').content()(function() {
        var quickSelectUserRegion = this.quickSelectUserRegion;

        return [
            this.quickSelectRegions && {
                block: 'b-regions',
                elem: 'quick-controls-section',
                content: [
                    {
                        elem: 'quick-controls-head',
                        content: iget2('b-regions', 'bystryy-vybor', 'Быстрый выбор')
                    },
                    {
                        elem: 'quick-select-list',
                        regions: this.quickSelectRegions
                    }
                ]
            },
            quickSelectUserRegion && {
                block: 'b-regions',
                elem: 'quick-controls-section',
                content: [
                    {
                        elem: 'quick-controls-head',
                        content: iget2('b-regions', 'vash-region', 'Ваш регион')
                    },
                    {
                        elem: 'quick-select',
                        id: quickSelectUserRegion.id,
                        name: quickSelectUserRegion.name
                    }
                ]
            },
            !!(this.independentRegions && this.independentRegions.length) && {
                block: 'b-regions',
                elem: 'independent-filter-warning',
                mix: {
                    elem: 'quick-controls-section'
                }
            }
        ];
    }),

    elem('quick-select-list').content()(function() {

        return this.ctx.regions.map(
            function(region) {
                // region.id может быть числом или массивом
                if (!this.disableRegions ||
                    u._.intersection(this.disableRegions, [].concat(region.id)).length ==
                    0) {
                    return {
                        elem: 'quick-select',
                        id: region.id,
                        name: region.name
                    };
                }
            }, this);
    }),

    elem('quick-select').def()(function() {

        return applyCtx(
            {
                block: 'link',
                mods: { pseudo: 'yes', theme: 'ghost' },
                mix: [
                    {
                        block: 'b-regions',
                        elem: 'quick-select',
                        elemMods: { id: this.ctx.id },
                        js: { id: this.ctx.id }
                    }
                ],
                content: this.ctx.name
            });
    }),

    elem('reset-selected').def()(function() {
        return applyCtx(
            {
                block: 'link',
                mods: { pseudo: 'yes', theme: 'ghost' },
                mix: {
                    block: 'b-regions',
                    elem: 'reset-selected'
                },
                content: iget2('b-regions', 'ochistit-regiony', 'Очистить регионы')
            });
    })
);
