BEM.DOM.decl('b-regions', {

    onSetMod: {

        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._searchInput = this.findBlockOn('search-input', 'input');
            this._searchInput.getDataprovider().init(this._getRegionsTree().getRegionsNames());

            this._subscriptionManager.wrap(this._getRegionsTree())
                .on('independent-checkboxes-filtered', function() {
                    this.setMod('has-independent-filter-warning', 'yes');
                }, this)
                .on('independent-checkboxes-reset', function() {
                    this.delMod('has-independent-filter-warning');
                }, this)
        }
    },

    /**
     * Поиск
     * returns {BEM}
     */
    search: function() {
        var query = $.trim(this._searchInput.val()),
            result;

        this.hideSearchResult();

        if (query) {
            result = this._getRegionsTree().partialSearch(query);
            !result && this.setMod(this.elem('no-search-result'), 'visible', 'yes');
        }

        return this;
    },

    /**
     * Скрыть результаты поиска
     * returns {BEM}
     */
    hideSearchResult: function() {
        this.delMod(this.elem('no-search-result'), 'visible');

        this._getRegionsTree().resetAllHighlights();

        return this;
    },

    /**
     * Устанавливает выбор регионов
     * @param {Array} regions Массив регионов
     * @param {Boolean} [skipIndependent] не менять состояние у вложенных независисмых чекбоксов
     * @returns {BEM}
     */
    setSelectedRegions: function(regions, skipIndependent) {
        this._getRegionsTree().setTreeState(regions, skipIndependent);

        return this;
    },

    /**
     * Устанавливает выбор регионов из быстрого выбора
     * @param {Array} regions Массив регионов
     * @param {Boolean} [skipIndependent] не менять состояние у вложенных независисмых чекбоксов
     * @returns {BEM}
     */
    setQuickRegions: function(regions, skipIndependent) {
        this._getRegionsTree().setFromQuickLinks(regions, skipIndependent);

        return this;
    },

    /**
     * Возвращает информацию о выбранных регионах в виде объекта {ids, text}
     * @returns {{ids: (string|number), text: (string|*), changesInfo: Object, resolvedRegions: Object, wasReset: boolean}}
     */
    getRegionsData: function() {
        var treeState = this._getRegionsTree().getTreeState(),
            treeReducer = function(ids, region) {
                var regionIds = [region.id];

                if (region.excluded.length) {
                    region.excluded.forEach(function(excluded) {
                        regionIds.push(-excluded.id);
                    });
                }

                ids.push.apply(ids, regionIds);

                return ids;
            },
            ids = treeState.state.reduce(treeReducer, []);

        return {
            ids: ids,
            text: this.__self.treeStateToText(treeState.state),
            changesInfo: treeState.changesInfo,
            resolvedRegions: treeState.resolvedRegions,
            wasReset: treeState.wasReset
        };
    },

    /**
     * Возвращает строку описывающую все регионы
     * @returns {*}
     */
    getAllRegionsText: function() {
        return this.__self.getAllRegionsText();
    },

    /**
     * Сбрасывает выбранные чекбоксы
     */
    resetTree: function() {
        this._getRegionsTree().reset();
    },

    /**
     * Устанавливает родительский попап
     * @param {BEM.DOM<popup>} parentPopup - родительский попап
     */
    setParentPopup: function(parentPopup) {
        this._getRegionsTree().setParentPopup(parentPopup);
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    _getRegionsTree: function() {
        return this._regionsTree || (this._regionsTree = this.findBlockInside('b-regions-tree'));
    },

    /**
     * Обработчик события клика блока link
     * @param {Event} e
     */
    _handleLinkClick: function(e) {
        var domElem = e.block.domElem;

        if (this.elem('quick-select').is(domElem)) {
            var regions = this.elemParams(this.elemify(e.block.domElem, 'quick-select')).id;

            if (regions) {
                this.setQuickRegions([].concat(regions), true);
            }
        } else if (this.elem('reset-selected').is(domElem)) {
            this.resetTree();
        }
    },

    /**
     * Обработчик нажатий на символьные клавиши при открытом саджесте
     * @param {DOMEvent} e DOM-событие нажатия клавиши
     */
    _handleKeypress: function(e) {
        // если в саджесте ничего не выбрано и нажали ENTER
        if (e.which === BEM.blocks.keycodes.ENTER && this._searchInput._curItemIndex == -1) {
            this
                .search()
                ._searchInput.getPopup().hide();
        }
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('click', 'link', function(e) {
                this._handleLinkClick(e);
            })
            .liveBindTo('search-input', 'keypress', function(e) {
                this._handleKeypress(e);
            })
            .liveInitOnBlockInsideEvent('change', 'input', u._.debounce(function(event) {
                this.elemify(event.block.domElem).is(this.elem('search-input')) && this.search();
            }, 200))
            // при выборе из саджеста должен подсвечиваться единственный вариант
            .liveInitOnBlockInsideEvent('select', 'input', function(event) {
                var currentVal = this._searchInput.val(),
                    regionsTreeBlock = this._getRegionsTree();

                u._.delay(function() {
                    regionsTreeBlock.search(currentVal);
                }, 250);
            });
    },

    /**
     * Возвращает текст с пояснением для выбора всех элементов дерева
     * @returns {String}
     */
    getAllRegionsText: function() {
        return iget2(
            'b-regions',
            'rossiya-sng-isklyuchaya-rossiyu',
            'Россия, СНГ (исключая Россию), Европа, Азия, Африка, Северная Америка, Южная Америка, Австралия и Океания'
        );
    },

    /**
     * Переводит состояние выбора в дереве в его текстовое описание
     * @param {Object} treeState Объект с состоянием дерева
     * @returns {String}
     */
    treeStateToText: function(treeState) {
        var texts = treeState.reduce(function(texts, region) {
            var regionText = region.name;

            if (region.excluded.length) {
                regionText += ' (' + iget2('b-regions', 'krome', 'кроме ').trim() + ': ' +
                    region.excluded.map(function(excluded) { return excluded.name }).join(', ') + ')';
            }

            texts.push(regionText);

            return texts;
        }, []);

        return texts.join(', ') || this.getAllRegionsText();
    }
});
