/**
 * "Группа правил"
 * @param {String} ctx._entityId уникальное значение, для контроллера. по нему он определит, какой элемент массива
 *     изменяется
 * @param {Object} ctx.type тип "группы правил"
 * @param {Array} ctx.ruleCollection коллекция "правил"
 * @param {Boolean} ctx.isReadOnly только для чтения
 *
 * @namespace b-retargeting-condition-edit-group-rule
 */
block('b-retargeting-condition-edit-group-rule')(

    js()(function() {
        return {
            _entityId: this.ctx._entityId,
            isReadOnly: this.ctx.isReadOnly
        }
    }),

    attrs()(function() {
        return {
            and: iget2('b-retargeting-condition-edit-group-rule', 'i', 'и')
        };
    }),

    mix()(function() {
        var ruleLength = this.ctx.ruleCollection.length,
            value;

        if (ruleLength > 99) {
            value = 'hundreds';
        } else if (ruleLength > 9) {
            value = 'tens';
        } else {
            value = 'few';
        }

        return {
            block: this.block,
            mods: {
                'rule-length': value
            }
        }
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'body',
                content: [
                    {
                        elem: 'name',
                        content: [
                            iget2('b-retargeting-condition-edit-group-rule', 'nabor-pravil', 'Набор правил '),
                            {
                                elem: 'index',
                                tag: 'span'
                            },
                            {
                                block: 'link',
                                mods: {
                                    theme: 'ghost',
                                    pseudo: 'yes',
                                    inner: 'yes',
                                    icon: 'active',
                                    disabled: ctx.isReadOnly ? 'yes': ''
                                },
                                mix: {
                                    block: this.block,
                                    elem: 'group-rule-remove'
                                },
                                attrs: {
                                    title: iget2('b-retargeting-condition-edit-group-rule', 'udalit', 'Удалить')
                                },
                                content: [
                                    {
                                        block: 'icon',
                                        mods: { 'size-16': 'delete' },
                                        mix: { block: 'link', elem: 'icon' }
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        block: 'radio-button',
                        js: { live: true },
                        mods: { disabled: ctx.isReadOnly ? 'yes' : '' },
                        value: ctx.type,
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: {
                                    value: 'OR'
                                },
                                content: iget2('b-retargeting-condition-edit-group-rule', 'vypolneno-hotya-by-odno', 'Выполнено хотя бы одно')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: {
                                    value: 'ALL'
                                },
                                content: iget2('b-retargeting-condition-edit-group-rule', 'vypolneny-vse', 'Выполнены все')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: {
                                    value: 'NONE'
                                },
                                content: iget2('b-retargeting-condition-edit-group-rule', 'ne-vypolneno-ni-odnogo', 'Не выполнено ни одного')
                            }
                        ]
                    },
                    {
                        elem: 'rule-collection',
                        content: ctx.ruleCollection.map(function(rule) {
                            return {
                                block: 'b-retargeting-condition-edit-group-rule',
                                elem: 'rule-template',
                                rule: rule,
                                _entityId: rule._entityId,
                                isReadOnly: ctx.isReadOnly
                            };
                        })
                    },
                    {
                        elem: 'create-rule-wrap',
                        content:  {
                            block: 'link',
                            mods: {
                                theme: 'ghost',
                                pseudo: 'yes',
                                inner: 'yes',
                                icon: 'active',
                                disabled: ctx.isReadOnly ? 'yes' : ''
                            },
                            mix: {
                                block: this.block,
                                elem: 'create-rule'
                            },
                            content: [
                                {
                                    block: 'icon',
                                    mods: { 'size-16': 'plus' },
                                    mix: { block: 'link', elem: 'icon' }
                                },
                                {
                                    elem: 'inner',
                                    content: iget2('b-retargeting-condition-edit-group-rule', 'dobavit-pravilo', 'Добавить правило')
                                }
                            ]
                        }
                    }
                ]
            }
        ];
    })
);
