/**
 * Редактирование "группы правила"
 *
 * @events create-rule                  создать "правило" в "группе правил"
 * @events remove-group-rule            удалить "группу правил"
 * @events change-group-rule            изменения в данных "группы правил"
 *
 * addRuleToCollection                  добавляем правило в группу
 *
 *
 * @namespace b-retargeting-condition-edit-group-rule
 */
BEM.DOM.decl('b-retargeting-condition-edit-group-rule', /** @lends b-retargeting-condition-edit-group-rule */{

    onSetMod: {
        /**
         * @this b-retargeting-condition-edit-group-rule
         */
        js: function() {
            this._fieldType = this.findBlockInside('radio-button');
            this._fieldType.on('change', this._onChangeGroupRule, this);
            this.findBlockOn('group-rule-remove', 'link').on('click', this._onRemoveGroupRule, this);
            this.findBlockOn('create-rule', 'link').on('click', this._onCreateRule, this);
        }
    },

    /**
     * Добавляет "правило" в список
     * @param { {type, _entityId, day } } rule
     * @returns BEM
     * @public
     */
    addRuleToCollection: function(rule) {
        return BEM.DOM.append(
            this.elem('rule-collection'),
            BEMHTML.apply({
                block: 'b-retargeting-condition-edit-group-rule',
                elem: 'rule-template',
                rule: rule,
                _entityId: rule._entityId,
                isReadOnly: this.params.isReadOnly
            })
        ).bem('b-retargeting-condition-edit-rule');
    },

    /**
     * Удаляет "группу правил"
     * @returns {Boolean}
     * @private
     */
    _onRemoveGroupRule: function() {
        this.trigger('remove-group-rule', this.params._entityId);
    },

    /**
     * Создает новое "правило" в "группе правил"
     * @private
     */
    _onCreateRule: function() {
        this.trigger('create-rule', this.params._entityId);
    },

    /**
     * Получает тип "группы правил"
     * @returns {String}
     * @private
     */
    _getType: function() {
        return this._fieldType.val();
    },

    /**
     * Обработчик события изменения данных в "группе правил"
     * @private
     */
    _onChangeGroupRule: function() {
        this.trigger('change-group-rule', {
            _entityId: this.params._entityId,
            type: this._getType()
        });
    }
});
