/**
 * Название и примечание
 * Если не передан comment - добавить модификатор блоку
 *
 * @param {String} ctx.name название "условия"
 * @param {String|null} ctx.comment комментарий к "условию"
 * @param {Boolean} ctx.isReadOnly только для чтения
 * @namespace b-retargeting-condition-edit-name
 */
block('b-retargeting-condition-edit-name')(

    js()(true),

    content()(function() {
        var ctx = this.ctx;

        if (!ctx.comment) {
            this.mods['comment-hide'] = 'yes';
        }

        return [
            {
                elem: 'row',
                mix: { elem: 'name' },
                content: [
                    [
                        {
                            elem: 'label',
                            content: iget2('b-retargeting-condition-edit-name', 'nazvanie', 'Название')
                        },
                        {
                            block: 'input',
                            mods: ctx.isReadOnly && { disabled: 'yes' },
                            placeholder: iget2('b-retargeting-condition-edit-name', 'vvedite-nazvanie', 'введите название'),
                            content: [
                                { elem: 'control' }
                            ],
                            value: ctx.name
                        },
                        {
                            block: 'link',
                            mods: {
                                theme: 'ghost',
                                pseudo: 'yes',
                                inner: 'yes',
                                icon: 'active',
                                disabled: ctx.isReadOnly ? 'yes': ''
                            },
                            mix: {
                                block: this.block,
                                elem: 'comment-add'
                            },
                            content: [
                                {
                                    block: 'icon',
                                    mods: { 'size-16': 'plus' },
                                    mix: { block: 'link', elem: 'icon' }
                                },
                                {
                                    elem: 'inner',
                                    content: iget2('b-retargeting-condition-edit-name', 'dobavit-primechanie', 'Добавить примечание')
                                }
                            ]
                        }
                    ]
                ]
            },
            {
                elem: 'row',
                mix: { elem: 'comment' },
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-retargeting-condition-edit-name', 'primechanie', 'Примечание')
                    },
                    {
                        block: 'input',
                        mods: ctx.isReadOnly && { disabled: 'yes' },
                        placeholder: iget2('b-retargeting-condition-edit-name', 'vvedite-primechanie', 'введите примечание'),
                        content: { elem: 'control' },
                        value: ctx.comment
                    },
                    {
                        block: 'link',
                        mix: {
                            block: this.block,
                            elem: 'comment-remove'
                        },
                        mods: {
                            theme: 'ghost',
                            pseudo: 'yes',
                            inner: 'yes',
                            icon: 'active',
                            disabled: ctx.isReadOnly ? 'yes': ''
                        },
                        attrs: {
                            title: iget2('b-retargeting-condition-edit-name', 'udalit-kommentariy', 'Удалить комментарий')
                        },
                        content: [
                            {
                                block: 'icon',
                                mods: { 'size-16': 'delete' },
                                mix: { block: 'link', elem: 'icon' }
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
