    /**
 * Название условия + комментарий
 *
 * this.ctx
 * @param {String} ctx.name название "условия подбора аудитории"
 * @param {String} ctx.comment комментарий
 *
 * @fires change(data)     произошли изменения в данных
 *
 * @namespace b-retargeting-condition-edit-name
 */
BEM.DOM.decl({ name: 'b-retargeting-condition-edit-name' }, /** @lends b-retargeting-condition-edit-name */{

    /**
     * Дочерние элементы/блоки
     */
    _fieldName: null,
    _fieldComment: null,

    onSetMod: {
        /**
         * @this b-retargeting-condition-edit-name
         */
        js: function() {
            this._fieldName = this.findBlockInside('name', 'input');
            this._fieldComment = this.findBlockInside('comment', 'input');

            this.findBlockOn('comment-add', 'link').on('click', this.addComment, this);
            this.findBlockOn('comment-remove', 'link').on('click', this.removeComment, this);

            this._fieldName.on('change', this._onChange, this);
            this._fieldComment.on('change', this._onChange, this);
        }
    },

    /**
     * Получить данные из полей ввода, провести их валиадцию
     * @returns {{name: String, comment: String}}
     * @public
     */
    getData: function() {
        var name = this._getName(),
            comment = this._getComment();

        return {
            name: name,
            comment: comment
        }
    },

    /**
     * Добавление комментария
     * @public
     */
    addComment: function() {
        this._fieldComment.val(this.params.comment);
        this.delMod('comment-hide');
    },

    /**
     * Удалить комментарий
     * @public
     */
    removeComment: function() {
        this.setMod('comment-hide', 'yes');
        this._fieldComment.val(null);
    },

    /**
     * Получить название
     * @returns {String}
     */
    _getName: function() {
        return this._fieldName.val().trim().replace(/\s{2,}/g, ' ');
    },

    /**
     * Получить комментарий
     * @returns {String}
     */
    _getComment: function() {
        return this._fieldComment.val().trim().replace(/\s{2,}/g, ' ');
    },

    /**
     * Изменение в данных
     * @private
     */
    _onChange: function() {
        this.trigger('change', this.getData())
    }
});
