/**
 * Название цели/сегмента для отображения на кнопке
 *
 * @param {String} ctx.name название "цели/сегмента"
 * @param {String} ctx.audienceTypeName тип сегмента аудитории
 */
block('b-retargeting-condition-edit-rule').elem('goal-name-caption')(
    match(function() { return this.ctx.audienceTypeName })(
        content()(function() {
            
            return [
                {
                    block: 'b-retargeting-condition-edit-rule',
                    elem: this.elem + '-name',
                    content: u.escapeHTML(this.ctx.name)
                },
                {
                    block: 'b-retargeting-condition-edit-rule',
                    elem: this.elem + '-type',
                    content: this.ctx.audienceTypeName
                }
            ]
        })
    ),
    
    match(function() { return !this.ctx.audienceTypeName })(
        def()(function() {
            return u.escapeHTML(this.ctx.name);
        })
    )
);
