/**
 * Название цели/сегмента
 *
 * @param {String} ctx.domain домен
 * @param {String} ctx.name название "цели/сегмента"
 */
block('b-retargeting-condition-edit-rule').elem('goal-name')(
    def()(function() {
        var ctx = this.ctx;

        return [ctx.domain, ctx.name]
            .filter(function(val) { return val })
            .join(' :: ');
    }),

    elemMod('type', 'ecommerce').def()(function() {
        var ctx = this.ctx;

        return iget2(
            'b-retargeting-condition-edit-rule',
            'ecommerce-name',
            'eCommerce: Покупка (счетчик № {counter})',
            {
                counter: String(ctx.counter)
            }
        );
    })
);
