/**
 * Содержимое popup - выбор цели метрики
 *
 * @param {{ id, disabled, name, domain}[]} [ctx.goalList] массив объектов - строк целей / сегментов в списке выбора
 * @param {Number} GOALS_MAX_LENGTH Максимальное кол-во элементов в списке, когда нет поля поиска
 */
block('b-retargeting-condition-edit-rule').elem('list-popup-content').elemMod('type', 'metrika-goal').content()(
    function() {

        var goalList = this.ctx.goalList,
            searchShow = goalList.length > this.ctx.GOALS_MAX_LENGTH;

        return {
            block: 'b-chooser',
            mods: {
                search: goalList.length > 10 ? 'yes' : '',
                'auto-position': 'yes'
            },
            content: [
                searchShow && {
                    block: this.block,
                    elem: 'list-popup-content-search',
                    content: {
                        block: 'b-chooser',
                        elem: 'search',
                        hint: iget2('b-retargeting-condition-edit-rule', 'nayti-cel', 'Найти цель')
                    }
                },
                {
                    elem: 'wrap',
                    content: goalList.length ? goalList.map(function(goal) {
                        var nameText = applyCtx({
                                block: 'b-retargeting-condition-edit-rule',
                                elem: 'goal-name',
                                elemMods: {
                                    type: goal.type === 'ECOMMERCE_GOAL' ? 'ecommerce' : ''
                                },
                                domain: goal.domain,
                                name: goal.name,
                                counter: goal.counter
                            });

                        return {
                            elem: 'item',
                            elemMods: {
                                disabled: goal.disabled ? 'yes' : '',
                                selected: goal.selected ? 'yes' : '',
                                hovered: goal.selected ? 'yes' : ''
                            },
                            js: {
                                search: {
                                    'name': nameText
                                },
                                type: goal.type,
                                goal: goal
                            },
                            name: goal.id,
                            content: {
                                elem: 'name',
                                mix: {
                                    block: 'b-retargeting-condition-edit-rule',
                                    elem: 'list-popup-content-item',
                                    elemMods: { type: 'metrika-goal' }
                                },
                                content: u.escapeHTML(nameText)
                            },
                            attrs: {
                                title: nameText
                            }
                        }
                    }) : {
                        block: this.block,
                        elem: 'list-popup-content-item-empty',
                        content: iget2('b-retargeting-condition-edit-rule', 'net-dostupnyh-celey', 'Нет доступных целей')
                    }
                },

                searchShow && {
                    elem: 'not-found',
                    content: 'ничего не найдено'
                },

                {
                    block: this.block,
                    elem: 'list-popup-content-footer-link',
                    url: u.metrika.getMetrikaUrl('list')
                },
                {
                    block: this.block,
                    elem: 'list-popup-content-footer',
                    content: {
                        block: 'link',
                        mods: {
                            theme: 'black-without-hover',
                            inner: 'yes'
                        },
                        url: u.metrika.getMetrikaUrl('list'),
                        target: 'blank',

                        content: [
                            {
                                block: 'icon',
                                mods: { 'size-16': 'metrica' },
                                mix: { block: 'link', elem: 'icon' }
                            },
                            {
                                elem: 'inner',
                                mix: {
                                    block: 'b-retargeting-condition-edit-rule',
                                    elem: 'list-popup-content-footer-link-source'
                                },
                                content: iget2('b-retargeting-condition-edit-rule', 'nastroit-celi-v-metrike', 'Настроить цели в Метрике')
                            }
                        ]
                    }
                }
            ]
        };
    });
