/**
 * Содержимое popup - выбор сегмента метрики
 *
 * @param {{ id, disabled, name, domain}[]} [ctx.listGoal] массив объектов - строк целей / сегментов в списке выбора
 * @param {Number} GOALS_MAX_LENGTH Максимальное кол-во элементов в списке, когда нет поля поиска
 */
block('b-retargeting-condition-edit-rule').elem('list-popup-content').elemMod('type', 'metrika-segment').content()(
    function() {

        var goalList = this.ctx.goalList,
            searchShow = goalList.length > this.ctx.GOALS_MAX_LENGTH;

        return {
            block: 'b-chooser',
            mods: {
                search: goalList.length > 10 ? 'yes' : '',
                'auto-position': 'yes'
            },

            content: [
                searchShow && {
                    block: 'b-retargeting-condition-edit-rule',
                    elem: 'list-popup-content-search',
                    content: {
                        block: 'b-chooser',
                        elem: 'search',
                        hint: iget2('b-retargeting-condition-edit-rule', 'nayti-segment', 'Найти сегмент')
                    }
                },
                {
                    elem: 'wrap',
                    content: goalList.length ? goalList.map(function(goal) {
                        var nameText = applyCtx({
                                block: 'b-retargeting-condition-edit-rule',
                                elem: 'goal-name',
                                domain: goal.domain,
                                name: goal.name
                            });

                        return {
                            elem: 'item',
                            elemMods: {
                                disabled: goal.disabled ? 'yes' : '',
                                selected: goal.selected ? 'yes' : '',
                                hovered: goal.selected ? 'yes' : ''
                            },
                            js: {
                                search: {
                                    'name': nameText
                                },
                                type: goal.type,
                                goal: goal
                            },
                            name: goal.id,
                            content: {
                                elem: 'name',
                                mix: {
                                    block: 'b-retargeting-condition-edit-rule',
                                    elem: 'list-popup-content-item',
                                    elemMods: { type: 'metrika-segment' }
                                },
                                content: u.escapeHTML(nameText)
                            },
                            attrs: {
                                title: nameText
                            }
                        }
                    }) : {
                        block: this.block,
                        elem: 'list-popup-content-item-empty',
                        content: iget2('b-retargeting-condition-edit-rule', 'net-dostupnyh-segmentov', 'Нет доступных сегментов')
                    }
                },
                searchShow && {
                    elem: 'not-found',
                    content: 'ничего не найдено'
                },
                {
                    block: this.block,
                    elem: 'list-popup-content-footer',
                    content: {
                        block: 'link',
                        mods: {
                            theme: 'black-without-hover',
                            inner: 'yes'
                        },
                        url: u.metrika.getMetrikaUrl('list'),
                        target: 'blank',

                        content: [
                            {
                                block: 'icon',
                                mods: { 'size-16': 'metrica' },
                                mix: { block: 'link', elem: 'icon' }
                            },
                            {
                                elem: 'inner',
                                content: iget2('b-retargeting-condition-edit-rule', 'nastroit-segmenty-v-metrike', 'Настроить сегменты в Метрике')
                            }
                        ]
                    }
                }
            ]
        };
    });
