/**
 * Список выбора счетчик "цели/сегмента"
 *
 * @param {String} ctx.name название выбранной "цели/сегмента"
 * @param {String} ctx.audienceTypeName тип выбранного сегмента аудитории
 * @param {Boolean} ctx.selected есть ли выбранное значение в списке целей
 */
block('b-retargeting-condition-edit-rule').elem('list').content()(function() {
    var ctx = this.ctx;

    return [
        {
            block: 'dropdown',
            mods: {
                selected: ctx.selected ? 'yes' : 'no'
            },
            content: [
                {
                    block: 'button',
                    mix: [
                        {
                            block: 'dropdown',
                            elem: 'switcher'
                        },
                        {
                            block: 'b-retargeting-condition-edit-rule',
                            elem: 'list-dropdown-button'
                        }
                    ],
                    mods: {
                        size: 's',
                        arrow: 'down'
                    },
                    content: {
                        block: 'b-retargeting-condition-edit-rule',
                        elem: 'goal-name-caption',
                        name: ctx.name,
                        audienceTypeName: ctx.audienceTypeName
                    }
                },
                {
                    elem: 'popup',
                    elemMods: { adaptive: 'yes', animate: 'no' },
                    mix: {
                        block: 'b-retargeting-condition-edit-rule',
                        elem: 'list-popup'
                    },
                    js: {
                        directions: [
                            {
                                to: 'bottom',
                                axis: 'left'
                            },
                            {
                                to: 'top',
                                axis: 'left'
                            }
                        ]
                    },
                    content: [
                        {
                            elem: 'content',
                            content: ''
                        }
                    ]


                }
            ]
        },
        {
            elem: 'notice'
        }
    ]
});
