/**
 * Сегменты аудиторий
 *
 * @param {String} ctx.name название выбранной цели / сегмента
 * @param {String} ctx.audienceTypeName суб-тип аудитории
 * @param {Boolean} ctx.selected есть ли выбранное значение в списке целей
 * @param {Boolean} ctx.allowToUse доступна ли выбранная цель/сегмент для использования
 */
block('b-retargeting-condition-edit-rule').elem('params-audience-segment')(

    replace()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'list',
                elemMods: {
                    'allow-to-use': ctx.allowToUse ? 'yes' : 'no'
                },
                name: ctx.name,
                audienceTypeName: ctx.audienceTypeName,
                selected: ctx.selected
            }
        ]
    })
);
