/**
 * Цели метрики
 *
 * @param {String} ctx.name название выбранной цели / сегмента
 * @param {Number} ctx.day кол-во дней
 * @param {Boolean} ctx.selected есть ли выбранное значение в списке целей
 * @param {Boolean} ctx.allowToUse доступна ли выбранная цель/сегмент для использования
 */
block('b-retargeting-condition-edit-rule').elem('params-metrika-goal')(
    replace()(function() {
        var ctx = this.ctx,
            readonly = this.mods.readonly;

        return [
            {
                elem: 'list',
                elemMods: {
                    'allow-to-use': ctx.allowToUse ? 'yes' : 'no'
                },
                name: ctx.name,
                selected: ctx.selected
            },

            iget2('b-retargeting-condition-edit-rule', 'over-input-label', '{over} {input} {label}', {
                over: function() {
                    return {
                        elem: 'field-day-over',
                        content: iget2('b-retargeting-condition-edit-rule', 'za', 'за')
                    };
                }(),

                input: function() {
                    return {
                        elem: 'field-day',
                        content: [
                            {
                                block: 'input',
                                js: { live: true },
                                mods: {
                                    clear: 'no',
                                    disabled: readonly ? 'yes' : ''
                                },
                                value: ctx.day,
                                content: { elem: 'control' }
                            }
                        ]
                    };
                }(),

                label: { elem: 'field-day-label' }
            })
        ];
    })
);
