/**
 * Cегменты метрики
 *
 * @param {String} ctx.name название выбранной цели / сегмента
 * @param {Number} ctx.day кол-во дней
 * @param {Boolean} ctx.selected есть ли выбранное значение в списке целей
 * @param {Boolean} ctx.allowToUse доступна ли выбранная цель/сегмент для использования
 */
block('b-retargeting-condition-edit-rule').elem('params-metrika-segment')(
    replace()(function() {
        var ctx = this.ctx,
            readonly = this.mods.readonly;

        return [
            {
                elem: 'list',
                elemMods: {
                    'allow-to-use': ctx.allowToUse ? 'yes' : 'no'
                },
                name: ctx.name,
                selected: ctx.selected
            }
        ];
    })
);
