/**
 * выбор типа цели / сегмента
 *
 * @params {String} ctx.type тип
 * @param {Boolean} ctx.isReadOnly только для чтения
 */
block('b-retargeting-condition-edit-rule').elem('type')(

    content()(function() {
        var ctx = this.ctx,
            type = ctx.type;

        return {
            block: 'select',
            js: { live: true },
            mods: {
                'on-scroll': 'close',
                layout: 'fixed',
                disabled: ctx.isReadOnly ? 'yes' : ''
            },
            value: this.ctx.type,
            content: [
                {
                    block: 'button'
                },
                {
                    elem: 'control',
                    content: [
                        {
                            elem: 'option',
                            attrs: {
                                value: 'METRIKA_GOAL'
                            },
                            content: iget2('b-retargeting-condition-edit-rule', 'cel-metriki', 'Цель Метрики')
                        },
                        {
                            elem: 'option',
                            attrs: {
                                value: 'METRIKA_SEGMENT'
                            },
                            content: iget2('b-retargeting-condition-edit-rule', 'segment-metriki', 'Сегмент Метрики')
                        },
                        {
                            elem: 'option',
                            attrs: {
                                value: 'AUDIENCE_SEGMENT'
                            },
                            content: iget2('b-retargeting-condition-edit-rule', 'segment-auditoriy', 'Сегмент Аудиторий')
                        }
                    ].map(function(item) {
                        if (item.attrs.value === type) {
                            item.attrs.selected = 'selected';
                        }
                        return item;
                    })
                }
            ]
        };
    })
);
