/**
 * @param {String} ctx._entityId уникальное значение, для контроллера.
 *                  по нему он определит, с каким объектом данных работать (изменять / удалять)
 * @param {RetargetingConditionRuleDTO} ctx.rule
 * @param {Boolean} ctx.isReadOnly только для чтения
 *
 * @namespace b-retargeting-condition-edit-rule
 */
block('b-retargeting-condition-edit-rule')(

    js()(function() {
        return {
            _entityId: this.ctx.rule._entityId,
            rule: this.ctx.rule,
            isReadOnly: this.ctx.isReadOnly
        }
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'fields',
                content: [
                    {
                        elem: 'index'
                    },
                    {
                        elem: 'type',
                        type: ctx.rule.type
                    },
                    {
                        elem: 'params'
                    }
                ]
            },
            {
                block: 'link',
                mods: {
                    theme: 'ghost',
                    pseudo: 'yes',
                    inner: 'yes',
                    icon: 'active',
                    disabled: ctx.isReadOnly ? 'yes': ''
                },
                mix: {
                    block: this.block,
                    elem: 'remove-rule'
                },
                attrs: {
                    title: iget2('b-retargeting-condition-edit-rule', 'udalit', 'Удалить')
                },
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'delete' },
                        mix: { block: 'link', elem: 'icon' }
                    }
                ]
            }
        ];
    })
);
