(function() {
    /**
     * Проверка на принадлежность числа к целым числам
     * @param {Number} x
     * @private
     */
    var _isInteger = function(x) {
        return x == Math.round(x);
    };

    u.register({

        /**
         * Редактирование условий подбора аудитории
         * @namespace b-retargeting-condition-edit-rule
         */
        'b-retargeting-condition-edit-rule': {

            /**
             * @type {Object} модификаторы блока, в зависимости от его типа
             */
            TYPE_VS_MOD: {
                METRIKA_GOAL: 'metrika-goal',
                METRIKA_SEGMENT: 'metrika-segment',
                AUDIENCE_SEGMENT: 'audience-segment'
            },

            /**
             * @type {Object} подпись на кнопке списка, когда не выбрана "цель/сегмент"
             */
            BUTTON_LABEL_LIST: {
                METRIKA_GOAL: iget2('b-retargeting-condition-edit-rule', 'viberite-cel', 'выберите цель'),
                METRIKA_SEGMENT: iget2('b-retargeting-condition-edit-rule', 'viberite-segment', 'выберите сегмент'),
                AUDIENCE_SEGMENT: iget2('b-retargeting-condition-edit-rule', 'viberite-segment', 'выберите сегмент')
            },

            /**
             * @type {Object} типы "правил", у которых есть поле дни
             */
            TYPE_HAS_DAY: {
                'METRIKA_GOAL': true,
                'ECOMMERCE_GOAL': true
            },

            /**
             * @type {number} максимальное валидное количество дней
             */
            MAX_DAYS: 540,

            /**
             * Проверка правила на валидность
             * @param {string} type
             * @param {number} [days]
             * @return {boolean}
             */
            isValidRule: function(type, days) {
                return u['b-retargeting-condition-edit-rule'].TYPE_HAS_DAY[type] ?
                    _isInteger(days) && days > 0 && days <= u['b-retargeting-condition-edit-rule'].MAX_DAYS :
                    true;
            }
        }
    });

})();
