/**
 * Сообщение для пользователя
 * @type {Object} ctx.message
 */
block('b-retargeting-condition-edit').elem('messages').content()(function() {
    var message = this.ctx.message || {};

    return [
        message.CHANGE_ONLY_ADJUSTMENT && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'alert'
            },
            text: {
                block: this.block,
                elem: 'msg-change-only-adjustment-text',
                mix: {
                    block: this.block,
                    elem: this.elem,
                    mods: { notice: 'yes' }
                },
                content: iget2(
                    'b-retargeting-condition-edit',
                    'v-uslovii-podbora-auditorii',
                    'В условии подбора аудитории нельзя изменять свойство "Не выполнено ни одного".'
                )
            }
        },

        message.READ_ONLY && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'alert'
            },
            text: {
                block: this.block,
                elem: 'msg-read-only-text',
                mix: {
                    block: this.block,
                    elem: this.elem,
                    mods: { notice: 'yes' }
                },
                content: iget2(
                    'b-retargeting-condition-edit',
                    'uslovie-nelzya-otredaktirovat-tak',
                    'Условие нельзя отредактировать, так как у вас нет доступных целей или сегментов.'
                )
            }
        },

        message.EXCEEDING_MAX_LENGTH_GROUP_RULE && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'alert'
            },
            text: {
                block: this.block,
                elem: 'msg-exceeding-max-length-group-rule-text',
                mix: {
                    block: this.block,
                    elem: this.elem,
                    mods: { notice: 'yes' }
                },
                content: iget2(
                    'b-retargeting-condition-edit',
                    'kolichestvo-naborov-v-uslovii',
                    'Количество наборов в условии подбора аудитории должно быть от 1 до 50.'
                )
            }
        },

        message.REACHED_MAX_LENGTH_GROUP_RULE && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'info'
            },
            text: {
                block: this.block,
                elem: 'messages-reached-max-length-group-rule-text',
                content: iget2(
                    'b-retargeting-condition-edit',
                    'dostignuto-maksimalnoe-kolichestvo-naborov',
                    'Достигнуто максимальное количество наборов правил в этом условии.'
                )
            }
        },

        message.NOT_CHANGE_SET_NEGATIVE && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'alert'
            },
            text: {
                block: this.block,
                elem: 'msg-not-change-set-negative-text',
                mix: {
                    block: this.block,
                    elem: this.elem,
                    mods: { notice: 'yes' }
                },
                content: iget2(
                    'b-retargeting-condition-edit',
                    'v-uslovii-podbora-auditorii-116',
                    'В условии подбора аудитории нельзя установить "Не выполнено ни одного".'
                )
            }
        },

        message.ONLY_ADJUSTMENT && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'info'
            },
            text: {
                block: this.block,
                elem: 'messages-only-adjustment-text',
                content: iget2(
                    'b-retargeting-condition-edit',
                    'eto-uslovie-podbora-auditorii',
                    'Это условие подбора аудитории можно будет использовать только для корректировки ставок.'
                )
            }
        },

        message.APPLY_ALL_CONDITIONS && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'info'
            },
            mix: {
                block: this.block,
                elem: this.elem,
                mods: { highlighted: 'yes' }
            },
            text: {
                block: this.block,
                elem: 'messages-apply-all-conditions-text',
                content: iget2(
                    'b-retargeting-condition-edit',
                    'izmenenie-budet-primeneno-ko',
                    'Изменение будет применено ко всем объявлениям с данным условием подбора аудитории.'
                )
            }
        },

        message.ERROR_WHEN_SAVING && {
            block: 'icon-text',
            mods: {
                size: 'xs',
                theme: 'alert'
            },
            text: {
                block: this.block,
                elem: 'messages-error-when-saving-text',
                mix: {
                    block: this.block,
                    elem: this.elem,
                    mods: { notice: 'yes' }
                },
                content: message.ERROR_WHEN_SAVING.content
            }
        }
    ].filter(function(item) { return item });
});
