BEM.DOM.decl({ name: 'b-retargeting-condition-edit', modName: 'type', modVal: 'groups-only'},  /** @lends b-retargeting-condition-edit */{

    _initNameEvents: function() {
        // в этом модификаторе их нет
    },

    _updateReadOnlyStatus: function() {
        // в этом модификаторе не требуется
    },

    /**
         * Возвращает текущие значения формы
         * @returns {Object}
         */
    getValue: function() {
        return this.model.toJSON().groupRuleCollection.slice(0);
    },

    /**
     * Обработчик события удаления группы правил
     * @param {Event} e
     * @param {String} entityId
     * @private
     */
    _onRemoveGroupRule: function(e, entityId) {
        this.model.removeGroupRule(entityId);
        e.block.destruct();
    },

    /**
     * Отрисовывает содержимое блока
     * @param {BEM.MODEL} model
     * @private
     */
    _renderBlock: function(model) {
        BEM.DOM.update(
            this.domElem,
            BEMHTML.apply(
                {
                    block: 'b-retargeting-condition-edit',
                    mods: {
                        type: 'groups-only'
                    },
                    elem: 'content-loaded',
                    isReadOnly: model.get('isReadOnly')
                })
        );
    },

    /**
     * Изменение сообщений/предупреждений которые видит пользователь
     * @param {Object} message данные
     * @private
     */
    updateMessage: function(message) {
        // их нет
    }

});
