/**
 * Условия подбора аудитории
 *
 * @param {Object} [ctx.conditionId] id условие ретаргетинга, переданное для редактирования. Если нет - создание нового
 * @namespace b-retargeting-condition-edit
 */
block('b-retargeting-condition-edit')(

    js()(function() {
        return {
            modelName: this.ctx.modelName,
            modelId: this.ctx.modelId
        }
    }),

    mix()(function() {
        return { block: 'b-errors-presenter2' };
    }),

    content()({ elem: 'content-loading' }),

    elem('content-loaded').replace()(function() {
        var ctx = this.ctx;

        return [
            {
                block: 'b-retargeting-condition-edit-name',
                name: ctx.name,
                comment: ctx.comment,
                isReadOnly: ctx.isReadOnly
            },
            {
                elem: 'group-rule-collection'
            },
            {
                elem: 'create-group-rule-wrap',
                isReadOnly: ctx.isReadOnly
            },
            {
                elem: 'messages'
            },
            {
                block: 'b-error-pretty-message',
                mix: { block: 'b-retargeting-condition-edit', elem: 'error-messages' },
                attrs: { 'data-err-path': '' }
            }
        ];
    })
);
