/**
 * Условия подбора аудитории
 *
 * @param {Object} [ctx.conditionId] id условие ретаргетинга, переданное для редактирования. Если нет - создание нового
 * @namespace b-retargeting-condition-wizard
 */
block('b-retargeting-condition-wizard').elem('forecast')(

    content()(function() {

        return [
            {
                elem: 'forecast-result',
                content: [
                    iget2('b-retargeting-condition-wizard', 'prognoziruemoe-kolichestvo-posetiteley', 'Прогнозируемое количество посетителей'),
                    ':&nbsp',
                    {
                        elem: 'forecast-count',
                        tag: 'span',
                        content: this.ctx.value
                    }
                ]
            },
            {
                elem: 'forecast-not-access',
                content: [
                    {
                        block: 'icon-text',
                        mods: {
                            size: 'xs',
                            theme: 'alert'
                        },
                        text: {
                            block: this.block,
                            elem: 'msg-read-only-text',
                            mix: {
                                block: this.block,
                                elem: this.elem,
                                mods: { notice: 'yes' }
                            },
                            content: iget2(
                                'b-retargeting-condition-wizard',
                                'prognoz-kolichestva-posetiteley-nedostupen',
                                'Прогноз количества посетителей недоступен.'
                            )
                        }
                    }
                ]
            },
            {
                elem: 'forecast-no-groups',
                content: [
                    {
                        block: 'icon-text',
                        mods: {
                            size: 'xs',
                            theme: 'info'
                        },
                        text: iget2(
                            'b-retargeting-condition-wizard',
                            'dlya-polucheniya-prognoza-v',
                            'Для получения прогноза в условии подбора аудитории должна быть хотя бы одна выполненная цель или сегмент.'
                        )
                    }
                ]
            }
        ]
    })
);
