BEM.DOM.decl({ name: 'b-retargeting-condition-wizard'}, {

    /**
     * Предоставляет объект работы с данными dataprovider
     * @type retargeting-dataprovider.utils
     */
    _dataProvider: null,

    /**
     * @type {RetargetingGoalDTO[]} загруженные цели/сегменты
     * необходимо сразу знать, есть ли выбор - что бы рендерить соответствующий элемент / показывать выбор
     */
    _goalList: null,

    /**
     * Флаги наличия целей определенного типа
     * @type {?{ METRIKA_GOAL, METRIKA_SEGMENT, AUDIENCE_SEGMENT }}
     */
    _hashGoalsByType: null,

    /**
     * Блок формы ретаргетинга
     */
    _form: null,

    /**
     * Состояние формы после последнего изменения
     */
    _lastState: {},

    /**
     * Последний прогноз
     */
    _lastPredict: null,

    /**
     * Инициализация
     */
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._dataProvider = u['retargeting-dataprovider'];
            this._initBlock();
        }
    },

    /**
     * Сообщает, было ли изменение, требующих сохранение
     * @returns {Boolean}
     */
    isChanged: function() {
        return this._form.isChanged();
    },

    /**
     * Сохраняет изменения
     * @param {String} mode если равно "SAVE_AS_NEW" - сохранить как новую запись
     * @returns {Promise<{ success: Boolean, operation: String, condition: RetargetingConditionDTO }>}
     * @throws String будет сообщение о причине исключения
     * @public
     */
    save: function(mode) {
        var values = this._form.getValue(),
            condition = values.condition,
            domains = values.domains,
            operation = condition.id ? 'CHANGE' : 'CREATE',
            data;

        switch (mode) {
            /**
             * данные существующей записи сохраним как новую
             */
            case 'SAVE_AS_NEW':
                condition.id = 0;
                operation = 'CREATE';
                break;
        }

        return this._dataProvider.saveCondition(u['retargeting-condition-dto'].RetargetingConditionDTOServer(condition))
            .then(function(response) {
                var msg;

                if (response.success) {
                    this._form.update({
                        'id': response.id,
                        'groupRuleCollectionIsChanged': false
                    });
                } else {
                    this._form.updateMessage(
                        {
                            ERRORS_WHEN_SAVING: {
                                value: response.validation_result.errors
                                    .map(u['retargeting-condition-dto'].RetargetingValidationError)
                                    .map(function(error) {
                                        return _.assign({}, error, {
                                            description: BEMHTML.apply(error.description)
                                        });
                                    })
                            }
                        }
                    );
                }

                return {
                    success: response.success,
                    operation: operation,
                    condition: u._.extend(
                        {},
                        response.condition,
                        {
                             // эти поля отправлять не сервер не нужно, поэтому в `RetargetingConditionDTOServer` их нет,
                             // но они нужны для моделей, которые создаются после
                             is_accessible: condition.isAccessible,
                             is_negative: condition.isNegative,
                             domains: domains
                        }
                    )
                };
            }.bind(this))
            .catch(function(response) {
                this._form.updateMessage(
                    {
                        ERRORS_WHEN_SAVING: {
                            value: [{
                                path: '',
                                description: iget2(
                                    'b-retargeting-condition-wizard',
                                    'pri-sohranenii-usloviya-podbora',
                                    'При сохранении условия подбора аудитории произошла ошибка'
                                )
                            }]
                        }
                    }
                );

                return { success: false };
            }.bind(this));
    },

    /**
     * Инициализация блока
     * @private
     */
    _initBlock: function() {
        var mode,
            conditionId = this.params.conditionId;

        this.getCondition(conditionId)
            .then(function(condition) {
                var model = BEM.MODEL.create(
                    'b-retargeting-condition-edit',
                    u._.extend({
                        mode: conditionId ? 'edit' : 'new'
                    }, condition)
                );

                BEM.DOM.update(this.elem('form'), BEMHTML.apply({
                    block: 'b-retargeting-condition-edit',
                    modelName: model.name,
                    modelId: model.id
                }));

                this._form = this.findBlockInside('b-retargeting-condition-edit');
            }.bind(this))
            .catch(function(e) {
                BEM.DOM.update(
                    this.elem('form'),
                    BEMHTML.apply({
                        block: 'icon-text',
                        mods: { size: 'xs', theme: 'notice' },
                        text: iget2(
                            'b-retargeting-condition-wizard',
                            'nevozmozhno-poluchit-spisok-dostupnyh',
                            'Невозможно получить список доступных целей/сегментов. Повторите попытку через несколько минут.'
                        )
                    })
                );
            }.bind(this));
    },

    /**
     * Получение данных цели (для редактирования)
     * @param {Number} conditionId - идентификатор условия
     */
    getCondition: function(conditionId) {
        return conditionId ?
            this._getCondition(conditionId).then(function(data) {
                return u['retargeting-condition-dto'].RetargetingConditionDTO(data);
            }) :
            Promise.resolve(u['retargeting-condition-dto'].RetargetingEmptyConditionDTO())
    },

    /**
     * Запрашивает данные редактируемого "условия подбора аудитории"
     * @param {Number} conditionId
     * @returns {Promise<RetargetingConditionDTO>}
     * @private
     */
    _getCondition: function(conditionId) {
        return this._dataProvider.getCondition(conditionId);
    },

    /**
     * Обновляет прогноз посетителей
     * @param {Event} e объект события, не используем
     * @param {Promise<Number|String>} promise промис выполнится, когда будут получены данные с сервера
     */
    _updateForecastVisitor: function(data) {
        var reqNum = 0,
            process = false;

        return function(data) {
            this.showForecast('result');

            if (!process) {
                onSpin.call(this);
                process = true;
            }

            reqNum++;

            return this._dataProvider.forecastVisitor(
                u['retargeting-condition-dto'].RetargetingConditionDTOServer(data)
            )
                .then(forecastResponseCallback.bind(this, reqNum, true))
                .catch(forecastResponseCallback.bind(this, reqNum, false));
        };

        /**
         * Показывает индикатор загрузки
         */
        function onSpin() {
            BEM.DOM.update(
                this.elem('forecast-count'),
                BEMHTML.apply({
                    block: 'spin',
                    mods: {
                        progress: 'yes',
                        theme: 'gray-16'
                    },
                    js: true
                })
            );
        }

        /**
         * Скрыть индикатор загрузки
         */
        function offSpin() {
            var spin = this.findBlockInside('forecast-count', 'spin');
            spin && spin.destruct();
        }

        /**
         * Обрабатывает ответ сервера
         * @param {Number} num
         * @param {Boolean} isSuccess
         * @param {Object} response
         */
        function forecastResponseCallback(num, isSuccess, response) {
            if (num === reqNum && this.domElem) {
                process = false;

                offSpin.call(this);

                if (!this._lastState.canPredict || this._lastState.isNegative) {
                    this.showForecast('hidden');
                } else {
                    if (!isSuccess) {
                        this.showForecast('not-access');
                    } else {

                        this.elem('forecast-count').text(
                            response.estimate > 10 ?
                                u.formatInt(response.estimate) :
                                iget2('b-retargeting-condition-edit', 'menee-10', 'менее 10')
                        );

                        this.showForecast('result');
                    }
                }
            }
        }
    }(),

    /**
     * Обработчик изменения групп в форме
     * @param data
     * @private
     */
    _onGroupsChange: function(data) {
        this._lastState = data;

        if (data.canPredict) {
            data.isGroupsValid && this._updateForecastVisitor(this._form.getValue().condition);
        } else {
            this.showForecast('no-groups');
        }

        if (data.canPredict && !data.isNegative) {
            this._lastPredict && this.showForecast('result');
        }

        if (data.isNegative || data.isReadOnly) {
            this.showForecast('hidden')
        }

    },

    showForecast: function(status) {
        this.setMod(this.elem('forecast'), 'status', status);
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('change', 'b-retargeting-condition-edit', function(e, data) {
                this.trigger('change', data);
            })
            .liveInitOnBlockInsideEvent('change-groups', 'b-retargeting-condition-edit', function(e, data) {
                this._onGroupsChange(data);
            })
            .liveInitOnBlockInsideEvent('ready', 'b-retargeting-condition-edit', function() {
                this.trigger('ready');
            })

        return false;
    }
});
