BEM.DOM.decl({ name: 'b-retargeting-conditions-list-item', modName: 'single-choice', modVal: 'yes' }, {
    /**
     * Инициализирует контрол для выбора условия
     * @override
     * @private
     */
    _initChooserControl: function() {
        this._chooser = this.findBlockOn('radiobox', 'radiobox');

        this._chooser.on('change', this._onChangeChooser, this);
    },

    /**
     * Обработчик события change на radiobox-е
     * @param {Event} event
     * @param {Object} eventData
     * @param {String} eventData.currentVal значение активированного radiobox-а
     * @override
     * @private
     */
    _onChangeChooser: function(event, eventData) {
        this.setMod('selected', eventData.currentVal == this.params.condition.ret_cond_id ? 'yes' : '');
    },

    /**
     * Обработчик события нажатия на строку условия (клик по строке условия должен работать как radiobox)
     * @param {Event} event
     * @override
     * @private
     */
    _onItemRowClick: function(event) {
        var targetElem = this.elemify(event.target),
            id = this.params.condition.ret_cond_id;

        // Если условие задизейбленно - не даем его выбрать
        if (this._chooser.isDisabled(this.elem('radio'))) {
            return;
        }

        // отменяем действие, в случае, когда клик произошел на элементе, содержащим контролы
        // вероятно, пользователь решил изменить данные
        if (this.findBlockOn(targetElem, 'button') ||
            this.findBlockOn(targetElem, 'link') ||
            this.findBlockOn(targetElem, 'icon')) {

            return;
        }

        if (this._chooser.val() !== id) {
            this._chooser.uncheckAll().val(id);
            this.trigger('change');
        }
    }
});
