/**
 * Строка списка условий подбора аудитори
 *
 * @param {Object} [ctx.conditions] список возможных условий ретаргетинга
 */
block('b-retargeting-conditions-list-item')(
    js()(function() {
        return {
            condition: this.ctx.condition,
            index: this.ctx.index
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            condition = ctx.condition,
            conditionDomains = condition.domains || [],
            conditionDescription = u.escapeHTML(condition.condition_desc),
            obj = (condition.campaigns || []).reduce(function(obj, cmp) {
                obj[cmp.cid] = cmp;
                return obj;
            }, {}),
            conditionCampaigns = Object.keys(obj).map(function(key) { return this[key] }, obj),
            conditionCampaignsNumber = conditionCampaigns.length;

        return [
            {
                elem: 'col',
                mix: {
                    elem: 'chooser'
                },
                content: {
                    elem: 'chooser-control',
                    condition: condition,
                    isSelected: this.mods.selected === 'yes'
                }
            },
            {
                elem: 'col',
                mix: {
                    elem: 'index'
                },
                content: ctx.index + '.'
            },
            {
                elem: 'col',
                mix: {
                    elem: 'name'
                },
                content: [
                    u.escapeHTML(condition.condition_name),
                   condition.is_negative && {
                        elem: 'adjustment-anchor'
                    }
                ]
            },
            {
                elem: 'col',
                mix: {
                    elem: 'site'
                },
                content: conditionDomains.length ? conditionDomains.join(', ') : ''
            },
            {
                elem: 'col',
                mix: {
                    elem: 'note'
                },
                content: conditionDescription ? {
                        elem: 'note-text',
                        content: conditionDescription.length > 40 ? conditionDescription.slice(0, 40) + '...' : conditionDescription,
                        attrs: {
                            title: conditionDescription.length > 40 ? conditionDescription : undefined
                        }
                    } :
                    ''
            },
            {
                elem: 'col',
                mix: {
                    elem: 'campaigns'
                },
                content: conditionCampaignsNumber ?
                    {
                        block: 'dropdown',
                        mix: {
                            block: 'b-retargeting-conditions-list-item',
                            elem: 'campaigns-dropdown'
                        },
                        content: [
                            {
                                block: 'button',
                                mix: [
                                    {
                                        block: 'dropdown',
                                        elem: 'switcher'
                                    },
                                    {
                                        block: 'b-retargeting-conditions-list-item',
                                        elem: 'button'
                                    }
                                ],
                                mods: { arrow: 'down', theme: 'plain' },
                                content: conditionCampaignsNumber
                            },
                            {
                                elem: 'popup',
                                elemMods: {
                                    animate: 'no',
                                    adaptive: 'yes'
                                },
                                mix: {
                                    block: 'b-retargeting-conditions-list-item',
                                    elem: 'campaigns-dropdown-popup'
                                },
                                js: {
                                    directions: ['bottom-left', 'top-left']
                                },
                                content: conditionCampaigns.map(function(campaign) {
                                    return {
                                        block: 'b-retargeting-conditions-list-item',
                                        elem: 'dropdown-campaign',
                                        campaign: campaign
                                    }
                                })
                            }
                        ]
                    } :
                    ''
            },
            {
                elem: 'col',
                content: [
                    {
                        block: 'button',
                        mods: { size: 'xs', theme: 'icon', 'only-icon': 'yes' },
                        mix: [
                            {
                                block: 'b-retargeting-conditions-list-item',
                                elem: 'button'
                            },
                            {
                                block: 'b-retargeting-conditions-list-item',
                                elem: 'edit'
                            }
                        ],
                        attrs: {
                            title: iget2('b-retargeting-conditions-list-item', 'redaktirovat', 'Редактировать')
                        },
                        content: {
                            block: 'icon',
                            mods: { 'size-16': 'edit', theme: 'light' },
                            mix: {
                                block: 'button',
                                elem: 'icon'
                            }
                        }
                    },
                    {
                        block: 'button',
                        mods: {
                            size: 'xs',
                            theme: 'icon',
                            'only-icon': 'yes',
                            // Условия, которые используются в кампаниях, удалить нельзя
                            disabled: conditionCampaignsNumber !== 0 ? 'yes' : ''
                        },
                        mix: [
                            {
                                block: 'b-retargeting-conditions-list-item',
                                elem: 'button'
                            },
                            {
                                block: 'b-retargeting-conditions-list-item',
                                elem: 'delete'
                            }
                        ],
                        attrs: {
                            title: iget2('b-retargeting-conditions-list-item', 'udalit', 'Удалить')
                        },
                        content:  {
                            block: 'icon',
                            mods: { 'size-16': 'delete', theme: 'light' },
                            mix: { block: 'button', elem: 'icon' }
                        }
                    }
                ]
            }
        ];
    })
);
