/**
 * @event b-retargeting-conditions-list-item#editCondition
 * @type {Object}
 * @property {String} conditionId идентификатор условия для редакторования
 *
 * @event b-retargeting-conditions-list-item#deleteCondition
 * @type {Object}
 * @property {String} conditionId идентификатор условия для удаления
 *
 * @fires b-retargeting-conditions-list-item#change событие изменения выбранности условия
 * @fires b-retargeting-conditions-list-item#editCondition событие нажатия на кнопку редактирования условия
 * @fires b-retargeting-conditions-list-item#deleteCondition событие нажатия на кнопку удаления условия
 */
BEM.DOM.decl('b-retargeting-conditions-list-item', {
    onSetMod: {
        js: function() {
            this.deleteBtn = this.findBlockOn('delete', 'button');
            this.editBtn = this.findBlockOn('edit', 'button');

            this._campaignDropdown = this.findBlockOn('campaigns-dropdown', 'dropdown');
            this._adjustmentAnchor = this.findBlockInside('adjustment-anchor', 'icon');
            this._adjustmentTooltip = this.findBlockInside('adjustment-anchor', 'tooltip');

            this._adjustmentTooltip && this._adjustmentTooltip.setOwner(this._adjustmentAnchor);

            this._initEvents();
        },

        'delete-progress': function(name, newValue) {
            this.deleteBtn.setMod('disabled', newValue);
        }
    },

    /**
     * Устанавливает выбранным/сбрасывает выбор условия ретаргетинга в зависимости от параметра
     * @param {Boolean} isSelected флаг выбранности условия ретаргетинга
     */
    toggleSelection: function(isSelected) {
        if (this._chooser.isDisabled()) {
            return;
        }

        if (isSelected != this._chooser.isChecked()) {
            this._chooser.toggle();
        }
    },

    /**
     * Возвращает порядковый номер условия ретаргетинга в списке условий
     */
    getIndex: function() {
        return this.params.index;
    },

    /**
     * Изменяет порядковый номер условия ретаргетинга
     * @param {Number} index новое значение порядкового номера
     */
    updateIndex: function(index) {
        this.elem('index').text(index + '.');
    },

    /**
     * Закрывает дропдаун со списком кампаний условия
     * @private
     */
    hideCampaignDropdown: function() {
        this._campaignDropdown && this._campaignDropdown.hide();
    },

    /**
     * Скрытие tooltip
     */
    hideAdjustmentTooltip: function() {
        this._adjustmentTooltip && this._adjustmentTooltip.delMod('shown');
    },

    /**
     * Подписывается на события контролов
     * @private
     */
    _initEvents: function() {
        this.editBtn.on('click', this._onEditButtonClicked, this);
        this.deleteBtn.on('click', this._onDeleteButtonClicked, this);

        this._initChooserControl();

        this.bindTo(this.domElem, 'pointerclick', this._onItemRowClick);

        // закрываем попап списка кампаний при клике на одну из кампаний
        this.bindTo('dropdown-campaign', 'click', this.hideCampaignDropdown);

        // показываем tooltip с подсказкой, что условие можно использовать только для корректоровки ставок
        this.bindTo('adjustment-anchor', 'click', function() {
            this._adjustmentTooltip.setMod('shown', 'yes');
        });
    },

    /**
     * Инициализирует контрол для выбора условия
     * @private
     */
    _initChooserControl: function() {
        this._chooser = this.findBlockOn('checkbox', 'checkbox');

        this._chooser.on('change', this._onChangeChooser, this);
    },

    /**
     * Обработчик события change на чекбоксах
     * @param {Event} event
     * @private
     */
    _onChangeChooser: function(event) {
        this.toggleMod('selected', 'yes', '', this._chooser.isChecked());

        this.trigger('change');
    },

    /**
     * Обработчик события нажатия на кнопку редактрования условия
     * @private
     */
    _onEditButtonClicked: function() {
        this.trigger('editCondition', { conditionId: this.params.condition.ret_cond_id });
    },

    /**
     * Обработчик события нажатия на кнопку удаления условия
     * @private
     */
    _onDeleteButtonClicked: function() {
        this.trigger('deleteCondition', { conditionId: this.params.condition.ret_cond_id });
    },

    /**
     * Обработчик события нажатия на строку условия (клик по строке условия должен работать как чекбокс)
     * @param {Event} event
     * @private
     */
    _onItemRowClick: function(event) {
        var targetElem = this.elemify(event.target);

        if (this.findBlockOn(targetElem, 'button') ||
            this.findBlockOn(targetElem, 'link') ||
            this.findBlockOn(targetElem, 'icon') ||
            targetElem.is(this._chooser.elem('control'))) {

            return;
        }

        !this._chooser.isDisabled() && this._chooser.toggle();
    }
});
