/**
 * Список условий подбора аудитории
 *
 * @param {Object} [ctx.singleChoice] флаг, отвечающий за возможность выбора нескольких условий ретаргетинга
 * @param {Object} [ctx.conditions] список возможных условий ретаргетинга
 */
block('b-retargeting-conditions-list')(

    mix().match(function() {
        return !this.ctx.singleChoice;
    })([{ block: 'b-checkboxes-group', js: true }]),

    js()(function() {
        return {
            singleChoice: this.ctx.singleChoice
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            conditions = ctx.conditions || [];

        return [
            {
                elem: 'list-controls',
                elemMods: { hidden: conditions.length ? '' : 'yes' },
                content: [
                    {
                        block: 'input',
                        mods: { size: 's', autofocus: 'yes' },
                        mix: [{
                            block: 'b-retargeting-conditions-list',
                            elem: 'search'
                        }],
                        content: [
                            {
                                elem: 'control'
                            }
                        ],
                        placeholder: iget2('b-retargeting-conditions-list', 'nayti', 'Найти')
                    },
                    {
                        elem: 'head',
                        hasAllChooser: !ctx.singleChoice
                    },
                    {
                        elem: 'body',
                        mix: this.mods['popup-decorated'] === 'yes' ?
                            [{
                                block: 'b-modal-popup-decorator',
                                elem: 'body'
                            }] :
                            [],
                        content: applyCtx({
                            block: 'b-retargeting-conditions-list',
                            elem: 'items-template',
                            conditions: conditions,
                            singleChoice: ctx.singleChoice
                        })
                    },
                    {
                        elem: 'search-empty',
                        elemMods: {
                            hidden: 'yes'
                        },
                        content: iget2('b-retargeting-conditions-list', 'nichego-ne-naydeno', 'Ничего не найдено')
                    }
                ]
            },
            {
                elem: 'empty',
                content: iget2('b-retargeting-conditions-list', 'ne-sozdano-ni-odnogo', 'Не создано ни одного условия'),
                elemMods: { hidden: conditions.length ? 'yes' : '' }
            },
            {
                elem: 'lower-bound'
            },
            {
                elem: 'add',
                content:  [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'plus' },
                        mix: { block: 'b-retargeting-conditions-list', elem: 'add-icon' }
                    },
                    iget2('b-retargeting-conditions-list', 'dobavit-uslovie', 'Добавить условие')
                ]
            },
            {
                elem: 'geo-hint',
                elemMods: { hidden: 'yes' },
                content:  [
                    {
                        block: 'icon',
                        mods: { 'size-13': 'info', theme: 'light' },
                        mix: { block: 'b-retargeting-conditions-list', elem: 'geo-hint-icon' }
                    },
                    iget2(
                        'b-retargeting-conditions-list',
                        'vybrannye-usloviya-soderzhat-segmenty',
                        'Выбранные условия содержат сегменты геолокаций. Убедитесь, что содержащиеся в них местоположения не выходят за пределы регионов показа, заданных для данной группы объявлений, иначе по ним не будет показов.'
                    )
                ]
            }
        ];
    })
);
