BEM.DOM.decl('b-shared-popup', {

    _mods: null,

    _popup: null,

    onSetMod: {
        js: function() {
            this._mods = [];
            this._popup = this.findBlockOn('popup');

            this._implantEvents(this._popup);
        },

        '*': function(modName) {
            this._mods && this._mods.push(modName);
        }
    },

    /**
     * Скрывает блок
     * @return {BEM}
     */
    hide: function() {
        this._popup.hide();

        return this;
    },

    /**
     * Показывает блок
     * @param {Object|jQuery} params - принимает объект с параметрами
     * @return {BEM}
     */
    show: function(params) {
        var popup = this._popup;

        // лезем в кишки, так как в api попапа нет метода сброса родительского попапа
        popup._parent = null;
        popup._isParentFixed = false;

        popup.show(params);

        return this;
    },

    /**
     * Прокси метода от popup-а
     * @param {BEM.DOM} parent родительский попап
     */
    setParent: function(parent) {
        this._popup.setParent(parent);
    },

    /**
     * Показывает/скрывает блок в зависимости от текущего состояния.
     * Поведение метода изменено относительно такого же метода попапа
     * для правильного поведения при смене владельца
     * @param {jQuery|Object} [owner] DOM-элемент или координаты { left : x, top : y },
     * относительно которых рассчитывается положение
     */
    toggle: function(owner) {
        var popup = this._popup,
            currentOwner = popup._owner;

        if (owner instanceof BEM) {
            owner = owner.domElem;
        }

        // если нет владельца или он не меняется, то работает метод попапа
        if (!currentOwner || owner && currentOwner.get(0) === owner.get(0)) {
            popup.toggle(owner);
        } else {
            // если владелец меняется, то показываем попап с новым владельцем
            this.show(owner);
        }

        return this;
    },

    /**
     * Возвращает свойство isShown попапа
     * @returns {Boolean}
     */
    isShown: function() {
        return this._popup.isShown();
    },

    /**
     * Возвращает текущего владельца попапа
     * @returns {JQuery}
     */
    getOwner: function() {
        return this._popup._owner;
    },

    /**
     * Устанавливает контент блока попапа
     * @param {String|JQuery} content
     * @param {Function} [callback] Обработчик, вызываемый после инициализации контента
     * @param {Object} [callbackCtx] контекст обработчика
     * @returns {BEM}
     */
    setContent: function(content, callback, callbackCtx) {
        this._cleanupMods();

        this._popup.setContent(content, callback, callbackCtx);

        return this;
    },

    destruct: function() {
        this._popup.destruct.apply(this._popup, arguments);
        this.__base.apply(this, arguments);
    },

    _cleanupMods: function() {
        this._mods
            .splice(0, this._mods.length)
            .forEach(function(modName) {
                this.delMod(modName);
            }, this);
    },

    /**
     * Перерисовываем попап
     * @return {Boolean}
     */
    repaint: function() {
        return this._popup.repaint();
    },

    /**
     * Имплантация событий попапа в экземпляр блока
     * @param {BEM} popup
     * @private
     */
    _implantEvents: function(popup) {
        ['show', 'hide'].forEach(function(eventName) {
            popup.on(eventName, function() {
                this.trigger(eventName, { owner: popup._owner });
            }, this);
        }, this);
    }

}, {

    _instances: {},

    /**
     * Создает инстанс попапа по ключу хэша переданных параметров попапа
     * @param {Object} [mods] модификаторы попапа
     * @param {Object} [jsParams] js параметры попапа
     * @param {Object} [mixes] миксы попапа
     * @param {Object} [underMods] модификаторы элемента under попапа
     * @return {BEM.DOM}
     */
    getInstance: function(mods, jsParams, mixes, underMods) {
        var pageElem,
            popup,
            key = JSON.stringify(mods || {}) + '/' + JSON.stringify(jsParams || {}) +
                '/' + JSON.stringify(mixes || {}) + '/' + JSON.stringify(underMods || {});

        if (!this._instances[key] || this._instances[key]._isDestructing) {
            pageElem = document.body;

            mixes || (mixes = {});

            popup = {
                block: 'popup',
                mix: [{ block: 'b-shared-popup', js: true }].concat(mixes.popup || []),
                js: jsParams || true,
                mods: mods,
                underMods: underMods || {},
                content: [{ elem: 'tail', mix: mixes.tail }, { elem: 'content', mix: mixes.content }]
            };

            this._instances[key] = $(BEMHTML.apply(popup)).appendTo(pageElem).bem('b-shared-popup');
        }

        return this._instances[key];
    }

});
