/**
 * Блок с шапкой для стратегий
 * Состоит из блока title (неизменнный)
 * Переключалки-табов tabs
 * И подписи, реагирующей на смену табов
 * Используется поле модели isNet
 */
block('b-strategy2-choose').elem('head')(

    mode('model')('b-strategy2-choose') ,

    content()(function() {
        return [
            {
                block: 'b-strategy2-choose',
                elem: 'title',
                tag: 'h3',
                content: iget2('b-strategy2-choose', 'strategiya-pokazov', 'Стратегия показов')
            },
            !this.ctx.disablePlatformChange && {
                block: 'b-strategy2-choose',
                elem: 'tabgroup',
                content: [
                    {
                        block: 'b-strategy2-choose',
                        elem: 'show-advs',
                        content: iget2('b-strategy2-choose', 'pokazyvat-reklamu', 'Показывать рекламу: ')
                    },
                    {
                        block: 'tabs',
                        mods: { control: 'buttons', size: 's', theme: 'normal' },
                        mix: [
                            { block: 'b-strategy2-choose', elem: 'tabbox' }
                        ],
                        content: this.ctx.platforms.map(function(platform) {
                            return {
                                block: 'tabs',
                                elem: 'tab',
                                mix: {
                                    block: 'b-strategy2-choose',
                                    elem: 'tab-' + platform.platform,
                                    elemMods: { disabled: platform.disabled ? 'yes': 'no' }
                                },
                                elemMods: { disabled: platform.disabled ? 'yes': 'no' },
                                content: platform.title
                            };
                        }, this)
                    }
                ]
            }
        ];
    }
));
