block('b-strategy2-choose').elem('strategies')(

    content()(function() {
        var handStrategies = this.ctx.strategies.handStrategies,
            autoStrategies = this.ctx.strategies.autoStrategies,
            autoFirst = this.ctx.strategies.autoFirst,
            handStrategiesItems,
            autoStrategiesItems;

        handStrategiesItems = handStrategies.map(function(strategy) {
            return {
                elem: 'item',
                name: strategy.name,
                content: strategy.title,
                elemMods: {
                    last: 'yes',
                    selected: strategy.selected ? 'yes': '',
                    disabled: strategy.disabled ? 'yes': ''
                },
                js: {
                    extraParams: { origName: strategy.name }
                }
            };
        });

        autoStrategiesItems = autoStrategies.map(function(strategy) {
            return {
                elem: 'item',
                name: strategy.name,
                content: strategy.title,
                elemMods: {
                    selected: strategy.selected ? 'yes': '',
                    disabled: strategy.disabled ? 'yes': ''
                },
                js: {
                    extraParams: { origName: strategy.name }
                }
            };
        });

        return {
            block: 'b-chooser',
            mods: { style: 'stretched-items', theme: 'strategies-list' },
            content: autoFirst ? [autoStrategiesItems, handStrategiesItems] : [handStrategiesItems, autoStrategiesItems]
        };
    })
);
