/**
 * Блок выбора стратегий
 * Параметры:
 * {Array} ctx.strategies – массив идентификаторов доступных для выбора стратегий
 * {Object} ctx.campDataModel – модель кампании
 * {String} ctx.campDataModel.name – название модели данных кампании
 * {String} ctx.campDataModel.id – id модели данных кампании
 */
block('b-strategy2-choose')(

    js()(function() {
        return {
            modelName: 'b-strategy2-choose',
            strategies: this.ctx.strategies,
            campaignPeriod: this.ctx.campaignPeriod,
            strategyModel: this.ctx.strategyModel,
            dayBudgetSettings: this.ctx.dayBudgetSettings,
            walletInfo: this.ctx.walletInfo,
            minAutobudgetAvgCpm: this.ctx.minAutobudgetAvgCpm,
            frontpageType: this.ctx.frontpageType,
            isChangeManualStrategyName: this.ctx.isChangeManualStrategyName,
            contextLimit: this.ctx.contextLimit,
            enable_cpc_hold: this.ctx.enable_cpc_hold,
            campaignType: this.ctx.campaignType,
            attributionModel: this.ctx.attributionModel,
            isSavedPeriodStrategyEditable: this.ctx.isSavedPeriodStrategyEditable,
            isCpaPayForConversionsStrategyAllowed: this.ctx.isCpaPayForConversionsStrategyAllowed,
            isCpaPayForConversionEnabled: this.ctx.isCpaPayForConversionEnabled,
            impressionStandardTime: this.ctx.impressionStandardTime,
            eshowsBannerRate: this.ctx.eshowsBannerRate,
            eshowsVideoRate: this.ctx.eshowsVideoRate,
            eshowsVideoType: this.ctx.eshowsVideoType
        };
    }),

    content()(function() {
        var disabledPlatforms = this.ctx.strategies.disabledPlatforms || [];

        return [
            {
                block: 'b-strategy2-choose',
                elem: 'head',
                platforms: [
                    { platform: u.strategy.ALL, title: iget2('b-strategy2-choose', 'na-vseh-ploshchadkah', 'На всех площадках'), disabled: disabledPlatforms.indexOf(u.strategy.ALL) >= 0 },
                    { platform: u.strategy.SEARCH, title: iget2('b-strategy2-choose', 'tolko-na-poiske', 'Только на поиске'), disabled: disabledPlatforms.indexOf(u.strategy.SEARCH) >= 0 },
                    { platform: u.strategy.NET, title: iget2('b-strategy2-choose', 'tolko-v-setyah', 'Только в сетях'), disabled: disabledPlatforms.indexOf(u.strategy.NET) >= 0 }
                ],
                mix: this.ctx.headerMix || {},
                disablePlatformChange: this.ctx.disablePlatformChange
            },
            {
                block: 'b-strategy2-choose',
                elem: 'body',
                mix: this.ctx.bodyMix || {},
                content: [
                    {
                        block: 'b-strategy2-choose',
                        elem: 'chooser-pane'
                    },
                    {
                        block: 'b-strategy2-choose',
                        elem: 'settings',
                        content: [
                            { elem: 'strategies-settings-panel' }
                        ]
                    }
                ]
            },
            {
                elem: 'toolbar',
                mix: this.ctx.footerMix || {},
                content: [
                    {
                        block: 'button',
                        content: iget2('b-strategy2-choose', 'sohranit', 'Сохранить'),
                        mods: { theme: 'action' },
                        mix: [
                            { block: 'b-strategy2-choose', elem: 'save' },
                            this.ctx.footerButtonMix
                        ]
                    },
                    {
                        block: 'button',
                        content: iget2('b-strategy2-choose', 'otmena', 'Отмена'),
                        mix: [
                            { block: 'b-strategy2-choose', elem: 'cancel' },
                            this.ctx.footerButtonMix
                        ],
                        type: 'button'
                    }
                ]
            }
        ];
    })
);
