/**
 * Элемент "Модели атрибуции"
 * @param {Boolean} ctx.attributionModel – выбранная модель атрибуции
 */
block('b-strategy2-settings').elem('attribution-model-control').replace()(function() {
    var ctx = this.ctx,
        modelData = ctx.modelData || {},
        currentStrategyName = ctx.currentStrategyName,
        attributionModel = modelData.attributionModel,
        mediaType = modelData.mediaType,
        attributionModels = [
            { name: iget2('b-strategy2-settings', 'last-direct-click', 'Последний переход из Яндекс.Директа'), id: 'last_yandex_direct_click' },
            { name: iget2('b-strategy2-settings', 'last-significant-click', 'Последний значимый переход'), id: 'last_significant_click' },
            { name: iget2('b-strategy2-settings', 'last-click', 'Последний переход'), id: 'last_click' }
        ];

    if (!u.campaign.isInternal(mediaType)) {
        attributionModels.push({ name: iget2('b-strategy2-settings', 'first-click', 'Первый переход'), id: 'first_click' });
    }

    return {
        elem: 'row',
        mix: [{
            block: 'b-strategy2-settings',
            elem: 'attribution-model-control'
        }],
        elemMods: {
            bordered: 'top'
        },
        content: [
            iget2('b-strategy2-settings', 'attribution-model', 'Модель атрибуции'),
            ':&nbsp;',
            {
                block: 'select',
                name: 'attribution_model',
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'metrics-attribution-select'
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'model-field',
                        js: [{
                            name: 'attributionModel',
                            type: 'select'
                        }]
                    }
                ],
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: attributionModels.map(function(model) {
                            var currModel = attributionModel,
                                isSelected = currentStrategyName === modelData.name && model.id === currModel,
                                attrs = {
                                    value: model.id,
                                    selected: isSelected  ? 'selected' : undefined
                                };

                            return {
                                elem: 'option',
                                attrs: attrs,
                                content: model.name
                            };
                        })
                    }
                ]
            },
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                width: 1110,
                stretched: true,
                url: u.getHelpUrl('attribution-model')
            }
        ]
    };
});
