block('b-strategy2-settings').elem('avg-cpa-control').replace()(function() {
    var currency = this.ctx.currency,
        visible = this.ctx.visible,
        strCurrency = this.ctx.strCurrency,
        cpa = this.ctx.cpa;

    return {
        elem: 'row',
        mix: [
            {
                block: 'b-strategy2-settings',
                elem: 'avg-cpa-control'
            },
            { elem: 'avg-cpa-control' }
        ],
        content: iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-avg', '{spend} {avg} {input} {week}', {
            spend: {
                elem: 'label',
                content: iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-param',
                    'Удерживать цену конверсии') + '&nbsp;'
            },

            avg: {
                elem: 'label',
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'cpa-avg-input-text'
                    },
                ],
                content: iget2('b-strategy2-settings',
                    'uderzhivanie-v-srednem', 'в среднем') + '&nbsp;'
            },

            input: {
                block: 'input',
                mods: { clear: 'no' },
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'cpa-input'
                    },
                    {
                        block: 'b-hintable',
                        js: true
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'model-field',
                        js: {
                            name: 'cpa',
                            type: 'formatted-input'
                        }
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'prevalidate-input',
                        js: {
                            highValue: u.currencies.getConst(currency, 'AUTOBUDGET_AVG_CPA_WARNING'),
                            modelField: 'cpa'
                        }
                    }
                ],
                value: cpa ?
                    u.numberFormatter.roundFormatted(cpa, {
                        precision: 2,
                        fail: ''
                    }) : '',
                content: { elem: 'control' }
            },

            week: {
                elem: 'label',
                content: [
                    {
                        tag: 'span',
                        content: '&nbsp;' + strCurrency
                    },
                    {
                        tag: 'span',
                        elem: 'period-week',
                        content: '&nbsp;' + iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-param-week', 'в неделю')
                    }
                ]
            },

            context: 'spend - Удерживать цену конверсии в среднем; week - в неделю'
        })
    };
});
