block('b-strategy2-settings').elem('control-cpa')(
    replace()(function() {
        var modelData = this.ctx.modelData,
            currency = this.ctx.currency,
            mediaType = modelData.mediaType,
            isCpaPayForConversionsStrategyAllowed = modelData.isCpaPayForConversionsStrategyAllowed,
            isCpaPayForConversionEnabled = modelData.isCpaPayForConversionEnabled,
            goalsLength = modelData.metrika.campaign_goals.length,
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(mediaType),
            goals = u.strategy.addRmpGoals(
                modelData.metrika.campaign_goals,
                true,
                mediaType,
                modelData.goalId
            ),
            hasNonDefaultGoals = modelData.hasNonDefaultGoals,
            metrikaCode = modelData.metrikaWarning && modelData.metrikaWarning.code || '',
            metrikaText = modelData.metrikaWarning && modelData.metrikaWarning.text || '',
            elements,
            disableAllGoalsOption = (modelData.isNewCamp || modelData.initGoalId !== '0') || goalsLength === 0,
            enableCpaPayForConversions = isCpaPayForConversionsStrategyAllowed && goals.length !== 0,
            allKeyGoalsSelected = modelData.goalId === u.consts('allKeyGoals');

        if (goalsLength === 0 && !rmpGoalsEnabled && !isCpaPayForConversionEnabled && !failedToFetchMetrika) {
            return {
                elem: 'metrika-warning',
                    elemMods: {
                    name: metrikaCode
                },
                text: metrikaText
            };
        }

        elements = {
            avgCpaControl: {
                elem: 'avg-cpa-control',
                currency: modelData.currency,
                strCurrency: currency,
                cpa: modelData.cpa
            },
            cpaPayForConversionsCheckbox: {
                elem: 'row',
                elemMods: {
                    'always-visible': 'yes'
                },
                content: [
                    {
                        block: 'checkbox',
                        mods: {
                            checked: (!allKeyGoalsSelected && isCpaPayForConversionEnabled) ? 'yes' : '',
                            disabled: allKeyGoalsSelected ? 'yes' : ''
                        },
                        mix: [
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'isCpaPayForConversionEnabled',
                                    type: 'checkbox'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'checkbox-control'
                            }
                        ],
                        text: iget2('b-strategy2-settings', 'pay-for-conversions', 'Оплата за конверсии'),
                    },
                    {
                        block: 'b-help-link',
                        mix: [
                            {
                                block: 'b-hintable-popup',
                                js: {
                                    hint: iget2('b-strategy2-settings', 'hint-pay-for-conversion', "При включении опции «Оплата за конверсии» вы платите за каждое достижение указанного вами целевого визита."),
                                    directions: ['bottom','right'],
                                    mixPopup: { block: 'b-strategy2-settings', elem: 'popup-conversion-hint' }
                                }
                            }
                        ]
                    }
                ]
            },
            goalIdControl: [
                failedToFetchMetrika && {
                    elem: 'row',
                    content: {
                        block: 'b-metrika-unavailable-warning'
                    }
                },
                !failedToFetchMetrika && {
                    elem: 'all-key-goals-unavailable-warning',
                    elemMods: {
                        'visible': modelData.showAllKeyGoalsUnavailableWarning
                    },
                    mix: {
                        elem: 'row'
                    }
                },
                {
                    elem: 'not-optimal-goal-notification',
                    elemMods: {
                        visible: modelData.goalId === '0'
                    },
                    mix: {
                        elem: 'row'
                    }
                },
                {
                    elem: 'row',
                    content: [
                        iget2('b-strategy2-settings', 'po-celi', 'По цели:'),
                        '&nbsp;',
                        {
                            elem: 'goal-select-special',
                            metrikaGoals: u.strategy.convertGoalsToSpecial(goals),
                            currentGoalId: modelData.goalId,
                            disableAllGoalsOption: true
                        },
                        {
                            elem: 'goal-select',
                            metrikaGoals: goals,
                            where: modelData.where,
                            currentGoalId: modelData.goalId,
                            minGoalsOnCampaign: modelData.minGoalsOnCampaign,
                            needKeyGoals: hasNonDefaultGoals,
                            disableAllGoalsOption: disableAllGoalsOption
                        }
                    ]
                }
            ],
            weekBidControl: {
                elem: 'week-bid-control',
                elemMods: {
                    collapsible: 'no'
                },
                weekBidEnabled: modelData.weekBidEnabled,
                weekBid: modelData.weekBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            notOptimalGoalNotification: !modelData.showAllKeyGoalsUnavailableWarning && {
                elem: 'all-key-goals-notification',
                elemMods: { hidden: 'yes' },
                mix: {
                    elem: 'row'
                },
            },
            maxClickBidControl: {
                elem: 'max-click-bid-control',
                maxClickBidEnabled: modelData.maxClickBidEnabled,
                maxClickBid: modelData.maxClickBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            metrikaWarning: !rmpGoalsEnabled && {
                elem: 'metrika-warning',
                elemMods: {
                    name: metrikaCode
                },
                text: metrikaText
            }
        };

        return [
            enableCpaPayForConversions && elements.cpaPayForConversionsCheckbox,
            elements.goalIdControl,
            elements.avgCpaControl,
            elements.notOptimalGoalNotification,
            elements.weekBidControl,
            elements.maxClickBidControl,
            elements.metrikaWarning
        ];
    })
);
