block('b-strategy2-settings').elem('control-roi')(
    replace()(function () {
        var modelData = this.ctx.modelData,
            mediaType = modelData.mediaType,
            hasNonDefaultGoals = modelData.meaningfulGoals.some(function (goal) {
                return goal.goal_id != u.consts('keyGoalsEngagedSessions');
            }),
            disableAllGoalsOption = (modelData.isNewCamp || modelData.initGoalId !== '0') || modelData.mediaType === 'performance',
            goals = u.strategy.addRmpGoals(
                modelData.metrika.campaign_goals,
                true,
                mediaType,
                modelData.goalId
            );

        return [
            {
                elem: 'all-key-goals-unavailable-warning',
                elemMods: {
                    'visible': modelData.showAllKeyGoalsUnavailableWarning
                },
                mix: {
                    elem: 'row'
                }
            },
            {
                elem: 'row',
                content: iget2('b-strategy2-settings', 'spend-uderzhivat-rentabelnost-investiciy', '{spend} {input}', {
                    spend: function (text) {
                        return {
                            elem: 'label',
                            content: text + '&nbsp;'
                        };
                    }(iget2(
                        'b-strategy2-settings',
                        'spend-uderzhivat-rentabelnost-investiciy-param-spend',
                        'Удерживать рентабельность инвестиций на уровне'
                    )),

                    input: function () {
                        return {
                            block: 'input',
                            mods: {clear: 'no'},
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'roi',
                                        type: 'formatted-input'
                                    }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'roi-input'
                                }
                            ],
                            value: isNaN(parseFloat(modelData.roi)) ?
                                '' :
                                u.numberFormatter.roundFormatted(modelData.roi, {
                                    precision: 2,
                                    fail: ''
                                }),
                            content: {elem: 'control'}
                        };
                    }.bind(this)(undefined),

                    context: 'spend - Удерживать рентабельность инвестиций на уровне'
                })
            },
            {
                elem: 'row',
                content: {
                    elem: 'roi-value-hint',
                    roi: modelData.roi,
                    currency: modelData.currency
                }
            },
            u.consts('failedToFetchMetrika') && {
                elem: 'row',
                content: {
                    block: 'b-metrika-unavailable-warning'
                }
            },
            {
                elem: 'row',
                content: [
                    iget2('b-strategy2-settings', 'po-celi', 'По цели:'),
                    ' ',
                    {
                        elem: 'goal-select',
                        disableAllGoalsOption: disableAllGoalsOption,
                        metrikaGoals: goals,
                        currentGoalId: modelData.goalId,
                        where: modelData.where,
                        minGoalsOnCampaign: modelData.minGoalsOnCampaign,
                        needKeyGoals: hasNonDefaultGoals
                    }
                ]
            },
            {
                elem: 'row',
                content: {
                    elem: 'not-optimal-goal-notification',
                    currentGoalId: modelData.goalId,
                }
            },
            {
                elem: 'row',
                content: iget2('b-strategy2-settings', 'spend-vozvrashchat-v-reklamu', '{spend} {select} {budget}', {
                    spend: function (text) {
                        return {
                            elem: 'label',
                            content: text
                        };
                    }(iget2('b-strategy2-settings', 'spend-vozvrashchat-v-reklamu-param-spend', 'Возвращать в рекламу')),

                    select: function () {
                        return {
                            block: 'select',
                            mix: [{
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'reserveReturn',
                                    type: 'select'
                                }
                            },
                                {
                                    block: 'b-strategy2-settings', elem: 'reserve-return'
                                }
                            ],
                            value: modelData.reserveReturn,
                            content: [
                                {
                                    block: 'button',
                                    mods: {
                                        size: 'xs',
                                        theme: 'normal'
                                    }
                                },
                                {
                                    elem: 'control',
                                    content: [100, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0].map(function (val) {
                                        return {
                                            elem: 'option',
                                            attrs: {
                                                value: val,
                                                selected: modelData.reserveReturn == val ? 'selected' : undefined
                                            },
                                            content: val + '%'
                                        };
                                    })
                                }
                            ]
                        };
                    }(),

                    budget: function (text) {
                        return {
                            elem: 'label',
                            content: text
                        };
                    }(iget2('b-strategy2-settings', 'spend-vozvrashchat-v-reklamu-param-budget', 'сэкономленного бюджета')),

                    context: 'spend - Возвращать в рекламу; budget - сэкономленного бюджета'
                })
            },
            {
                elem: 'row',
                elemMods: {collapsed: modelData.profitabilityEnabled ? '' : 'yes'},
                content: [
                    {
                        block: 'checkbox',
                        mods: {checked: modelData.profitabilityEnabled ? 'yes' : ''},
                        mix: [
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'profitabilityEnabled',
                                    type: 'checkbox'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'toggle-row'
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'profitability-enabled'
                            },
                        ],
                        text: iget2('b-strategy2-settings', 'utochnit-sebestoimost-tovara-ili', 'Уточнить себестоимость товара или услуги')
                    },
                    '&nbsp;',
                    {
                        elem: 'collapsing-area',
                        content: iget2('b-strategy2-settings', 'input-dohoda', '{input} % дохода', {
                            input: function () {

                                return {
                                    block: 'input',
                                    mods: {clear: 'no'},
                                    mix: [
                                        {
                                            block: 'b-strategy2-settings',
                                            elem: 'model-field',
                                            js: {
                                                name: 'profitability',
                                                type: 'formatted-input'
                                            }
                                        },
                                        {
                                            block: 'b-strategy2-settings',
                                            elem: 'profitability',
                                        }
                                    ],
                                    value: modelData.profitability ?
                                        u.numberFormatter.roundFormatted(modelData.profitability, {
                                            precision: 2,
                                            fail: ''
                                        }) :
                                        '',
                                    content: {elem: 'control'}
                                };
                            }()
                        })
                    }
                ]
            },
            {
                elem: 'week-bid-control',
                weekBidEnabled: modelData.weekBidEnabled,
                weekBid: modelData.weekBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            {
                elem: 'max-click-bid-control',
                maxClickBidEnabled: modelData.maxClickBidEnabled,
                maxClickBid: modelData.maxClickBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            {
                elem: 'metrika-warning'
            }
        ];
    })
);
