/**
 * Элемент для привязки полей модели к input
 */
block('b-strategy2-settings').elem('coverage-control-input').replace()(function() {
    return {
        block: 'input',
        mods: { clear: 'no' },
        mix: [
            {
                block: 'b-hintable',
                js: {
                    onScroll: 'close'
                },
            },
            {
                block: this.block,
                elem: 'model-field',
                js: {
                    name: this.ctx.field,
                    type: 'formatted-input'
                }
            },
            {
                block: 'b-strategy2-settings',
                elem: 'prevalidate-input',
                js: {
                    modelField: this.ctx.field
                }
            },
            {
                block: 'b-strategy2-settings',
                elem: 'coverage-control-input',
                elemMods: this.ctx.elemMods
            }
        ],
        value: this.ctx.value ? u.numberFormatter.roundFormatted(this.ctx.value, { precision: 2, fail: '' }) : '',
        content: { elem: 'control' }
    }
});
