/**
 * Элемент "Настройки автоматической стратегии для cpm_banner кампаний за период"
 * @param {Number} ctx.budget – ставка бюджета за период
 * @param {String} ctx.clickbidPeriod – средняя цена за 1000 показов за период
 * @param {String} ctx.coveragePeriodMode – показатель охвата(широкий или узкий)
 * @param {String} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('coverage-control-period-selector')(
    content()(function() {
        var ctx = this.ctx,
            calendar = ctx.calendar;

        if (this.ctx.controlMode === 'change'){
            return [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'label',
                            content: iget2('b-strategy2-settings', 'start-period', 'Начало периода')
                        },
                        {
                            elem: 'control-wrap',
                            content: {
                                block: 'b-date-input',
                                mix: [
                                    {
                                        block: 'b-strategy2-settings',
                                        elem: 'period-picker'
                                    },
                                    {
                                        block: 'b-strategy2-settings',
                                        elem: 'start-period'
                                    }
                                ],
                                mods: {
                                    disabled: 'yes'
                                },
                                value: calendar.start,
                                dateFormat: 'YYYY-MM-DD',
                                viewFormat: 'DD.MM.YYYY'
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'label',
                            content: iget2('b-strategy2-settings', 'end-period', 'Окончание периода')
                        },
                        {
                            elem: 'control-wrap',
                            content: {
                                block: 'b-date-input',
                                mix: [
                                    {
                                        block: 'b-strategy2-settings',
                                        elem: 'period-picker'
                                    },
                                    {
                                        block: 'b-strategy2-settings',
                                        elem: 'finish-period'
                                    }
                                ],
                                value: calendar.finish,
                                dateFormat: 'YYYY-MM-DD',
                                viewFormat: 'DD.MM.YYYY'
                            }
                        }
                    ]
                }
            ];
        }

        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-strategy2-settings', 'period', 'Период')
                },
                {
                    elem: 'control-wrap',
                    content: {
                        block: 'b-strategy2-settings',
                        elem: 'calendar',
                        calendar: calendar
                    }
                }
            ]
        };
    })
);
