/**
 * Элемент "Настройки автоматической стратегии для cpm_banner кампаний за период"
 * @param {Number} ctx.budget – ставка бюджета за период
 * @param {String} ctx.clickbidPeriod – средняя цена за 1000 показов за период
 * @param {String} ctx.coveragePeriodMode – показатель охвата(широкий или узкий)
 * @param {String} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('coverage-control-period').content()(function() {
    var ctx = this.ctx;

    return [
        {
            elem: 'coverage-control-period-selector',
            calendar: ctx.calendar
        },
        {
            elem: 'row',
            elemMods: { type: 'budget' },
            budget: ctx.budget,
            currency: ctx.currency,
            spendMode: 'period',
            coveragePeriodMode: ctx.coveragePeriodMode,
            period_range: ctx.period_range,
            field: 'budget'
        },
        {
            elem: 'row',
            content: [
                { elem: 'label' },
                {
                    elem: 'control-wrap',
                    content: [
                        {
                            block: 'checkbox',
                            mods: { checked: ctx.autoProlongation ? 'yes' : '' },
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'autoProlongation', // одно поле «autoProlongation» провязывает два чекбокса:
                                        type: 'checkbox'          // у превью и у редактирования(мы сейчас тут)
                                    }
                                }
                            ],
                            text: iget2('b-strategy2-settings', 'renew-automatically', 'Продлевать автоматически')
                        },
                        this.needHints && {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            mix: [{
                                block: 'b-strategy2-settings',
                                elem: 'help-icon'
                            }],
                            url: u.getHelpUrl('autoextension')
                        }
                    ]
                }
            ]
        },
        {
            elem: 'row',
            elemMods: { type: 'price' },
            spendMode: 'period',
            value: ctx.clickBidPeriod,
            field: 'clickBidPeriod',
            currency: ctx.currency,
            mediaType: ctx.mediaType
        },
        {
            elem: 'row',
            elemMods: { type: 'slider' },
            requestId: ctx.requestId,
            spendMode: 'period',
            currency: ctx.currency,
            value: ctx.clickBidPeriod,
            minAutobudgetAvgCpm: ctx.minAutobudgetAvgCpm
        },
        {
            elem: 'row',
            elemMods: { type: 'recommendation' },
            cid: ctx.cid,
            spendMode: 'period',
            coveragePeriodMode: ctx.coveragePeriodMode
        },
        {
            elem: 'row',
            elemMods: { type: 'forecast-description' },
            mix: {
                elem: 'row-forecast-description',
                elemMods: {
                    type: 'period',
                    hidden: 'yes'
                }
            },
            spendMode: 'period'
        }
    ]
});
