/**
 * Элемент "Настройки автоматической стратегии для cpm_banner кампаний за неделю"
 * @param {Number} ctx.weekBid – ставка недельного бюджета
 * @param {String} ctx.clickBid – средняя цена за 1000 показов за неделю
 * @param {String} ctx.coverageWeekMode – показатель охвата(широкий или узкий)
 * @param {String} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('coverage-control-week').content()(function() {
    var ctx = this.ctx;

    return [
        {
            elem: 'row',
            elemMods: { type: 'budget' },
            budget: ctx.weekBid,
            currency: ctx.currency,
            spendMode: 'week',
            coveragePeriodMode: ctx.coveragePeriodMode,
            field: 'weekBid'
        },
        {
            elem: 'row',
            elemMods: { type: 'price' },
            spendMode: 'week',
            value: ctx.clickBid,
            field: 'clickBid',
            currency: ctx.currency,
            mediaType: ctx.mediaType
        },
        {
            elem: 'row',
            elemMods: { type: 'slider' },
            requestId: ctx.requestId,
            spendMode: 'week',
            currency: ctx.currency,
            value: ctx.clickBid,
            minAutobudgetAvgCpm: ctx.minAutobudgetAvgCpm
        },
        {
            elem: 'row',
            elemMods: { type: 'recommendation' },
            cid: ctx.cid,
            spendMode: 'week',
            coverageWeekMode: ctx.coverageWeekMode
        },
        {
            elem: 'row',
            elemMods: { type: 'forecast-description' },
            mix: {
                elem: 'row-forecast-description',
                elemMods: {
                    type: 'week',
                    hidden: 'yes'
                }
            },
            spendMode: 'week'
        }
    ]
});
