/**
 * Элемент "Настройки автоматической стратегии для cpm_banner кампаний"
 * @param {Number} ctx.weekBid – ставка недельного бюджета
 * @param {Number} ctx.budget – ставка бюджета за период
 * @param {String} ctx.clickBid – средняя цена за 1000 показов за неделю
 * @param {String} ctx.clickBidPeriod – средняя цена за 1000 показов за период
 * @param {String} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('coverage-control')(

    def().match(function() {
        return u.strategy.isExpiredCpmPeriod(this.ctx.period.finish);
    })(function() {
        return applyNext({
            'elemMods.expired': 'yes',
            'ctx.isExpiredCpmPeriod': true
        });
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'period-preview',
                period: ctx.period || {},
                autoProlongation: ctx.autoProlongation,
                currency: ctx.currency,
                budget: ctx.budget,
                clickBidPeriod: ctx.clickBidPeriod,
                isExpiredCpmPeriod: ctx.isExpiredCpmPeriod,
                lastStrategyChange: ctx.lastStrategyChange,
                isSavedPeriodStrategyEditable: ctx.isSavedPeriodStrategyEditable
            },
            ctx.isSavedPeriodStrategyEditable && {
                elem: 'coverage-control-info'
            },
            {
                elem: 'row',
                elemMods: { type: 'spend-radiobox' },
                spendMode: ctx.spendMode
            },
            {
                elem: 'coverage-control-period',
                currency: ctx.currency,
                budget: ctx.budget,
                cid: ctx.cid,
                spendMode: ctx.spendMode,
                calendar: ctx.calendar,
                period_range: ctx.period_range,
                clickBidPeriod: ctx.clickBidPeriod,
                coveragePeriodMode: ctx.coveragePeriodMode,
                minAutobudgetAvgCpm: ctx.minAutobudgetAvgCpm,
                mediaType: ctx.mediaType,
                autoProlongation: ctx.autoProlongation
            },
            {
                elem: 'coverage-control-week',
                cid: ctx.cid,
                spendMode: ctx.spendMode,
                weekBid: ctx.weekBid,
                clickBid: ctx.clickBid,
                currency: ctx.currency,
                coverageWeekMode: ctx.coverageWeekMode,
                minAutobudgetAvgCpm: ctx.minAutobudgetAvgCpm,
                mediaType: ctx.mediaType
            }
        ];
    })
);
