/**
 * Контрол выбора цели Метрики
 * @params
 * {Number} [ctx.currentGoalId] – id текущей цели
 * {Array} [ctx.metrikaGoals] – массив целей (сериализованный dm-metrika-goal)
 * {String} [ctx.where] – принадлежность цели (контекст|поиск)
 * {Boolean} [ctx.disableAllGoalsOption] – флаг - разрешать ли опцию "все цели"
 */
block('b-strategy2-settings').elem('goal-select-special')(

    tag()('span'),

    content()(function() {
        var NAME_LENGTH = 100,
            currentGoalId = +(this.ctx.currentGoalId) || 0,
            metrikaGoals = this.ctx.metrikaGoals || [],
            options = [],
            conversionsByGoalId = u['b-strategy2-settings'].getConversionsByGoalId();

        metrikaGoals.reduce(function(accum, goal) {
            var goalName = (u.escapeHTML(u.hellipCut(goal.name, NAME_LENGTH))),
                conversions,
                conversionsAppendix;

            if (conversionsByGoalId) {
                conversions = +conversionsByGoalId[goal.id];
                if (conversionsByGoalId[goal.id] === undefined) {
                    conversionsAppendix = iget2('b-strategy2-settings', 'no-data', 'Нет данных');
                } else if (!conversions) {
                    conversionsAppendix = iget2('b-strategy2-settings', 'no-conversions', 'Нет конверсий');
                } else if (conversions < 20) {
                    conversionsAppendix = iget2('b-strategy2-settings', 'few-conversions', 'Мало конверсий');
                } else {
                    conversionsAppendix = iget2('b-strategy2-settings', 'enough-conversions', 'Достаточно конверсий');
                }
                goalName += ' · ' + conversionsAppendix;
            }

            accum.push({
                elem: 'option',
                attrs: {
                    value: String(goal.id),
                    selected: currentGoalId === +goal.id ? 'selected' : undefined,
                    conversionsMarked: conversionsAppendix !== undefined ? '1' : '0',
                    goal_type: goal.goal_type,
                    parent_goal_id: goal.parent_goal_id
                },
                content: goalName
            });

            return accum;
        }, options);

        return {
            block: 'select',
            js: {
                rows: 10
            },
            mix: [
                {
                    block: 'b-strategy2-settings',
                    elem: 'model-field',
                    js: [
                        {
                            name: 'goalSelectDisabled',
                            type: 'mod',
                            block: 'select',
                            modName: 'disabled'
                        },
                        {
                            name: 'goalId',
                            type: 'select'
                        }
                    ]
                },
                {
                    block: 'b-strategy2-settings',
                    elem: 'goal-select-special-control'
                }
            ],
            value: currentGoalId,
            content: [
                { block: 'button' },
                {
                    elem: 'control',
                    content: options
                }
            ]
        };
    })
);
