/**
 * Контрол выбора цели Метрики
 * @params
 * {Number} [ctx.currentGoalId] – id текущей цели
 * {Array} [ctx.metrikaGoals] – массив целей (сериализованный dm-metrika-goal)
 * {String} [ctx.where] – принадлежность цели (контекст|поиск)
 * {Boolean} [ctx.disableAllGoalsOption] – флаг - разрешать ли опцию "все цели"
 */
block('b-strategy2-settings').elem('goal-select')(

    tag()('span'),

    content()(function() {
        var currentGoalId = +(this.ctx.currentGoalId) || 0,
            metrikaGoals = this.ctx.metrikaGoals || [],
            options = u['b-strategy2-settings_goal-select'].getGoalsOptions({
                needKeyGoals: this.ctx.needKeyGoals,
                allKeyGoalsSelected: this.ctx.currentGoalId === u.consts('allKeyGoals'),
                disableAllGoalsOption: this.ctx.disableAllGoalsOption,
                metrikaGoals: metrikaGoals,
                currentGoalId: Number(this.ctx.currentGoalId)
            }),
            failedToFetchMetrika = u.consts('failedToFetchMetrika');

        return {
            block: 'select',
            js: {
                rows: 10
            },
            mix: [
                {
                    block: 'b-strategy2-settings',
                    elem: 'model-field',
                    js: [
                        {
                            name: 'goalSelectDisabled',
                            type: 'mod',
                            block: 'select',
                            modName: 'disabled'
                        },
                        {
                            name: 'goalId',
                            type: 'select'
                        }
                    ]
                },
                {
                    block: 'b-strategy2-settings',
                    elem: 'goal-select-control'
                }
            ],
            value: currentGoalId,
            content: [
                {
                    block: 'button',
                    mods: {
                        'metrika-failed': failedToFetchMetrika ? 'yes' : ''
                    }
                },
                {
                    elem: 'control',
                    content: options
                }
            ]
        };
    })
);
