u.register({
    'b-strategy2-settings_goal-select': {
        getGoalsOptions: function(settings) {
            var failedToFetchMetrika = u.consts('failedToFetchMetrika'),
                allKeyGoalsOption,
                options,
                NAME_LENGTH = 100,
                metrikaGoals = settings.metrikaGoals,
                conversionsByGoalId = settings.conversionsByGoalId;

            if (failedToFetchMetrika) {
                return [
                    {
                        elem: 'option',
                        attrs: {
                            value: settings.currentGoalId
                        },
                        content: iget2('b-strategy2-settings', 'goal-unavailable', 'Цель временно недоступна')
                    }
                ];
            }

            allKeyGoalsOption = (settings.needKeyGoals || settings.allKeyGoalsSelected) && {
                elem: 'option',
                attrs: {
                    value: u.consts('allKeyGoals'),
                    selected: settings.allKeyGoalsSelected ? 'selected' : undefined,
                },
                content: iget2('b-strategy2-settings', 'all-key-goals', 'всем ключевым целям')
            };

            options = settings.disableAllGoalsOption ? u._.compact([
                {
                    elem: 'option',
                    attrs: { value: '' },
                    content: iget2('b-strategy2-settings', 'vyberite-cel', 'Выберите цель')
                },
                allKeyGoalsOption
            ]) : u._.compact([
                {
                    elem: 'option',
                    attrs: {
                        value: '0',
                        selected: settings.currentGoalId === '0' ? 'selected' : undefined
                    },
                    content: iget2('b-strategy2-settings', 'vsem-celyam', 'всем целям')
                },
                allKeyGoalsOption
            ]);

            metrikaGoals.reduce(function(acc, goal) {
                var goalAvailable = goal.counter_status === 'Active' && goal.goal_status == 'Active' || +goal.goal_id === +settings.currentGoalId;

                if (goalAvailable) {
                    var goalName = '&mdash;',
                        conversions,
                        conversionsAppendix;

                    if (goal.goal_name) {
                        goalName = u.escapeHTML(u.hellipCut(goal.goal_name, NAME_LENGTH));
                        if (goal.status === 'Deleted') {
                            goalName += ' (' + iget2('b-strategy2-settings', 'udalena', 'удалена') + ')';
                        }

                        if (conversionsByGoalId) {
                            conversions = +conversionsByGoalId[goal.goal_id];
                            if (conversionsByGoalId[goal.goal_id] === undefined) {
                                conversionsAppendix = iget2('b-strategy2-settings', 'no-data', 'Нет данных');
                            } else if (!conversions) {
                                conversionsAppendix = iget2('b-strategy2-settings', 'no-conversions', 'Нет конверсий');
                            } else if (conversions < 20) {
                                conversionsAppendix = iget2('b-strategy2-settings', 'few-conversions', 'Мало конверсий');
                            } else {
                                conversionsAppendix = iget2('b-strategy2-settings', 'enough-conversions', 'Достаточно конверсий');
                            }
                            goalName += ' · ' + conversionsAppendix;
                        }

                    }

                    acc.push({
                        elem: 'option',
                        attrs: {
                            value: goal.goal_id,
                            selected: +(settings.currentGoalId) === +(goal.goal_id) ? 'selected' : undefined,
                            conversionsMarked: conversions !== undefined ? '1' : '0',
                            goal_type: goal.goal_type,
                            parent_goal_id: goal.parent_goal_id
                        },
                        content: goalName
                    });
                }

                return acc;
            }, options);

            options.forEach(function(option) {
                option.content = option.content.toLowerCase()
            });

            return options;
        }
    }
});
