/**
 * Элемент "Уточнить максимальную цену клика"
 * @param {Boolean} ctx.maxClickBidEnabled – установлено ли ограничение максимальной цены клика
 * @param {Number} ctx.maxClickBid – максимальная цена клика
 * @param {String} ctx.labelText – текст для лейбла чекбокса
 */
block('b-strategy2-settings').elem('max-click-bid-control').replace()(function() {
    var maxClickBidEnabled = this.ctx.maxClickBidEnabled,
        maxClickBid = this.ctx.maxClickBid,
        isReadOnly = this.ctx.isReadOnly,
        labelText = this.ctx.labelText || iget2('b-strategy2-settings', 'utochnit-maksimalnuyu-cenu-klika', 'Уточнить максимальную цену клика');

    return {
        elem: 'row',
        mix: [
            {
                block: 'b-strategy2-settings',
                elem: 'max-click-bid-control'
            },
            { elem: 'max-click-bid-control' }
        ],
        elemMods: { collapsed: maxClickBidEnabled ? '' : 'yes' },
        content: [
            {
                block: 'checkbox',
                mods: { checked: maxClickBidEnabled ? 'yes' : '' },
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'model-field',
                        js: {
                            name: 'maxClickBidEnabled',
                            type: 'checkbox'
                        }
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'toggle-row'
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'max-click-bid-toggle'
                    }
                ],
                text: labelText
            },
            '&nbsp;',
            {
                elem: 'collapsing-area',
                content: [
                    {
                        block: 'input',
                        mods: {
                            clear: 'no',
                            disabled: isReadOnly ? 'yes' : ''
                        },
                        mix: [
                            {
                                block: 'b-hintable',
                                js: true
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'maxClickBid',
                                    type: 'formatted-input'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'input-control',
                                elemMods: { field: 'maxClickBid' }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'prevalidate-input',
                                js: {
                                    highValue: u.currencies.getConst(this.ctx.currency, 'AUTOBUDGET_MAX_PRICE_WARNING'),
                                    modelField: 'maxClickBid'
                                }
                            }
                        ],
                        value: maxClickBid ?
                            u.numberFormatter.roundFormatted(maxClickBid, {
                                precision: 2,
                                fail: ''
                            }) : '',
                        content: { elem: 'control' }
                    },
                    '&nbsp;' + u.currencies.getName(this.ctx.currency)
                ]
            }
        ]
    };
});
