/**
 * Элемент "Отображение настроек автоматической стратегии для cpm_banner кампаний"
 */
block('b-strategy2-settings').elem('period-preview').content()(function() {
    var ctx = this.ctx,
        isAvgCpv = this.modelData.isAvgCpv,
        label = iget2(
            'b-strategy2-settings',
            'text-keep-cpm-at-the-level',
            'Средняя цена не более {cpm} за тысячу показов',
            {
                cpm: {
                    elem: 'highlighted-text',
                    content: u.currencies.formatSum(ctx.currency, ctx.clickBidPeriod)
                },
                context: 'cpm - числовое значение и валюта'
            }
        );

    if (isAvgCpv) {
        label = iget2(
            'b-strategy2-settings',
            'text-keep-avg-cpv-at-the-level',
            'Средняя цена {cpv} за просмотр',
            {
                cpv: {
                    elem: 'highlighted-text',
                    content: u.currencies.formatSum(ctx.currency, ctx.clickBidPeriod)
                },
                context: 'cpv - числовое значение и валюта'
            }
        );
    }

    return [
        {
            elem: 'row',
            elemMods: {
                type: 'period-preview'
            },
            content: [
                {
                    elem: 'highlighted-text',
                    elemMods: {
                        type: 'title'
                    },
                    content: iget2('b-strategy2-settings', 'current-setting', 'Текущая настройка')
                },
                {
                    elem: 'text',
                    content: iget2('b-strategy2-settings', 'spend-period-start-finish', 'Тратить в период с {start} по {finish}', {
                        start: {
                            elem: 'highlighted-text',
                            content: u.moment(ctx.period.start).format('DD.MM.YYYY')
                        },
                        finish: {
                            elem: 'highlighted-text',
                            content: u.moment(ctx.period.finish).format('DD.MM.YYYY')
                        }
                    })
                },
                {
                    elem: 'text',
                    content: u.spacer2([
                        iget2('b-strategy2-settings', 'label-budget', 'Бюджет'),
                        {
                            elem: 'highlighted-text',
                            content: u.currencies.formatSum(ctx.currency, ctx.budget)
                        }
                    ])
                },
                {
                    elem: 'text',
                    content: u.spacer2([label])
                },
                {
                    elem: 'auto-prolongation-wrapper',
                    content: [
                        {
                            block: 'checkbox',
                            mods: {
                                disabled: ctx.isExpiredCpmPeriod ? 'yes' : '',
                                checked: ctx.autoProlongation ? 'yes' : ''
                            },
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'auto-prolongation',
                                    elemMods: { type: 'preview-progress' }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'autoProlongation', // одно поле «autoProlongation» провязывает два чекбокса:
                                        type: 'checkbox'          // у превью(мы сейчас тут) и у редактирования
                                    }
                                }
                            ],
                            text: iget2('b-strategy2-settings', 'renew-automatically', 'Продлевать автоматически')
                        },
                        // фейковый чекбокс, что бы при изменении «auto-prolongation» у настроек стратегии не трогать
                        // «auto-prolongation» превью
                        {
                            block: 'checkbox',
                            mods: {
                                disabled: 'yes',
                                checked: ctx.autoProlongation ? 'yes' : ''
                            },
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'auto-prolongation',
                                elemMods: { type: 'preview-edit' }
                            },
                            text: iget2('b-strategy2-settings', 'renew-automatically', 'Продлевать автоматически')
                        },
                        this.needHints && {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            mix: [{
                                block: 'b-strategy2-settings',
                                elem: 'help-icon'
                            }],
                            url: u.getHelpUrl('autoextension')
                        }
                    ]
                },
                ctx.isExpiredCpmPeriod ?
                    {
                        block: 'icon-text',
                        mods: { theme: 'alert', size: 'ms' },
                        mix: [{ block: 'b-strategy2-settings', elem: 'warning-text' }],
                        text: iget2('b-strategy2-settings', 'strategy-warning-not-relevant-period', 'Период настройки стратегии неактуален, замените его на новый')
                    } :
                    '',
                ctx.isSavedPeriodStrategyEditable && ctx.lastStrategyChange && {
                    elem: 'changes-info',
                    lastStrategyChange: ctx.lastStrategyChange
                }
            ]
        },
        {
            elem: 'row',
            elemMods: {
                type: 'change-period-controls'
            },
            content: [
                ctx.isSavedPeriodStrategyEditable
                    && !ctx.isExpiredCpmPeriod
                    && u.moment(ctx.period.start) <= u.moment() && {
                    block: 'button2',
                    mods: {
                        theme: 'normal',
                        size: 's'
                    },
                    mix: {
                        block: 'b-strategy2-settings',
                        elem: 'change-period'
                    },
                    content: {
                        elem: 'text',
                        content: iget2('b-strategy2-settings', 'change-period', 'Редактировать')
                    }
                },

                {
                    block: 'button2',
                    mods: {
                        theme: 'normal',
                        size: 's'
                    },
                    mix: {
                        block: 'b-strategy2-settings',
                        elem: 'recreate-period'
                    },
                    content: {
                        elem: 'text',
                        content: iget2('b-strategy2-settings', 'create-new-period', 'Создать с новым периодом')
                    }
                }
            ]
        }
    ]
});
