/**
 * Элемент для общего использования, radio-button контрол и проклеивает его с полем подели
 * @param {String} ctx.fieldName – имя поля модели для
 * @param {String} ctx.value – текущее значение
 * @param {Array} ctx.options – массив доступных вариантов
 * @param {Object} ctx.optionsLabels – хеш с текстами опций, ключи элементы ctx.options,
 */
block('b-strategy2-settings').elem('radio-button').def()(function() {
    return applyCtx({
        block: 'radio-button',
        name: this.ctx.fieldName,
        value: this.ctx.value,
        mix: [
            {
                block: 'b-strategy2-settings',
                elem: 'model-field',
                js: {
                    name: this.ctx.fieldName,
                    type: 'radio-button'
                }
            },
            {
                block: 'b-strategy2-settings',
                elem: 'radio-button'
            },
            this.ctx.mix
        ],
        content: this.ctx.options.map(function(target) {
            return {
                elem: 'radio',
                controlAttrs: { value: target },
                content: this.ctx.optionsLabels[target]
            };
        }, this)
    });
});
